package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import java.util.List;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * SwitchSearchServiceJobNode switches the index used by a SearchService whose profile id is in 'search_service_ID' env param.
 * 
 * @author claudio, alessia
 * 
 */
public class SwitchSearchServiceJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(SwitchSearchServiceJobNode.class);
	private static final String BB_ACTION_SWITCH_INDEX = "UpdateIndex";

	private String inputIndexIdParam;

	private String outputIndexIdParam;


	@Override
	protected String obtainServiceId(final NodeToken token) {
		final String id = token.getEnv().getAttribute("search_service_ID");
		if(StringUtils.isBlank(id))  throw new RuntimeException("No id found in env attribute 'search_service_ID'");
		else return id;
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(BB_ACTION_SWITCH_INDEX);
		String indexId = token.getEnv().getAttribute(getInputIndexIdParam());

		checkParam(getInputIndexIdParam(), "output indexId param is missing");
		checkParam(indexId, "indexId is required to perform switch");
		log.info("Switching "+obtainServiceId(token)+" to index "+indexId);
		job.getParameters().put(getOutputIndexIdParam(), indexId);
	}

	private void checkParam(final String param, final String msg) throws MSROException {
		if (StringUtils.isBlank(param)) throw new MSROException(msg);
	}

	public String getInputIndexIdParam() {
		return inputIndexIdParam;
	}

	public void setInputIndexIdParam(final String inputIndexIdParam) {
		this.inputIndexIdParam = inputIndexIdParam;
	}

	public String getOutputIndexIdParam() {
		return outputIndexIdParam;
	}

	public void setOutputIndexIdParam(final String outputIndexIdParam) {
		this.outputIndexIdParam = outputIndexIdParam;
	}

}
