package eu.dnetlib.msro.openaireplus.workflows.nodes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class CheckHDFSCountJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(CheckHDFSCountJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** Name of the env param where to find the number to check. **/
	private String numberToVerifyParamName;
	/** Name of the enc param where to find the number of records stored to hdfs. **/
	private String hdfsCounterParamName = "mainlog:storeHdfsRecords:count";

	/**
	 * {@inheritDoc}
	 * 
	 * @throws MSROException
	 * 
	 * @see com.googlecode.sarasvati.mem.MemNode#execute(com.googlecode.sarasvati.Engine, com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	public String execute(final NodeToken token) throws MSROException {
		int hdfsCount = 0;
		int hbaseCount = 0;
		String numberToVerifyInEnvParam = WorkflowsConstants.BLACKBOARD_PARAM_PREFIX + numberToVerifyParamName;
		hbaseCount = getValueFromEnv(token, numberToVerifyInEnvParam);
		hdfsCount = getValueFromEnv(token, hdfsCounterParamName);

		if (hdfsCount != hbaseCount) {
			log.warn("Numbers are not the same. Number to verify (hbase count): " + hbaseCount + ". From hdfs: " + hdfsCount);
			log.warn((hdfsCount - hbaseCount) + " records come without a 'metadata' field");
			token.getEnv().setAttribute("noMetadataRecords", hdfsCount - hbaseCount);
		}
		return Arc.DEFAULT_ARC;

	}

	private int getValueFromEnv(final NodeToken token, final String paramName) throws MSROException {
		String valueString = token.getEnv().getAttribute(paramName);
		int number = 0;
		try {
			number = Integer.parseInt(valueString);
		} catch (NumberFormatException e) {
			log.error("Env param name: " + paramName + " is " + valueString + " and cannot be parsed as integer");
			throw new MSROException(e);
		}
		return number;
	}

	public String getNumberToVerifyParamName() {
		return numberToVerifyParamName;
	}

	public void setNumberToVerifyParamName(final String numberToVerifyParamName) {
		this.numberToVerifyParamName = numberToVerifyParamName;
	}

	public String getHdfsCounterParamName() {
		return hdfsCounterParamName;
	}

	public void setHdfsCounterParamName(final String hdfsCounterParamName) {
		this.hdfsCounterParamName = hdfsCounterParamName;
	}

}
