<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('ec__________')" />
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::EC')" />

	<xsl:template match="/">
		<xsl:variable name="specificProgramName">
			<xsl:choose>
				<xsl:when test="normalize-space(.//ProjectSpecificProgram)">
					<xsl:value-of select="normalize-space(.//ProjectSpecificProgram)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="string('UNKNOWN')" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="programName">
			<xsl:choose>
				<xsl:when test="normalize-space(.//ProjectProgram)">
					<xsl:value-of select="normalize-space(.//ProjectProgram)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="string('UNKNOWN')" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="specificProgramDesc" select=".//ProjectSpecificProgramDescr" />
		<xsl:variable name="specificProgramId"
			select="normalize-space(concat($funderID, '::FP7::', $specificProgramName))" />
		<xsl:variable name="programDesc" select=".//ProjectProgramDescr" />
		<xsl:variable name="programId"
			select="concat($funderID, '::FP7::', $specificProgramName, '::', $programName)" />

		<fundingtree>
			<funder>
				<id>
					<xsl:value-of select="$funderID" />
				</id>
				<shortname>EC</shortname>
				<name>European Commission</name>
				<jurisdiction>EU</jurisdiction>
			</funder>
			<funding_level_2>
				<id>
					<xsl:value-of select="$programId" />
				</id>
				<description>
					<xsl:value-of select="$programDesc" />
				</description>
				<name>
					<xsl:value-of select="$programName" />
				</name>
				<class>ec:program</class>
				<parent>
					<funding_level_1>
						<id>
							<xsl:value-of select="$specificProgramId" />
						</id>
						<description>
							<xsl:value-of select="$specificProgramDesc" />
						</description>
						<name>
							<xsl:value-of select="$specificProgramName" />
						</name>
						<class>ec:specificprogram</class>
						<parent>
							<funding_level_0>
								<id><xsl:value-of select="concat($funderID, '::FP7')" /></id>
								<description>SEVENTH FRAMEWORK PROGRAMME</description>
								<name>FP7</name>
								<parent />
								<class>ec:frameworkprogram</class>
							</funding_level_0>
						</parent>
					</funding_level_1>
				</parent>
			</funding_level_2>
		</fundingtree>
	</xsl:template>

</xsl:stylesheet>
