<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" version="1.0"
                exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('fwf_________')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::FWF')"/>

	<xsl:template match="/">
		<xsl:variable name="fundingName" select="normalize-space(.//column[@name='Grant_Type'])"/>
		<xsl:variable name="fundingCode" select="normalize-space(.//column[@name='Grant_Type_Code'])"/>
		<fundingtree>
			<funder>
				<id><xsl:value-of select="$funderID"/></id>
				<shortname>FWF</shortname>
				<name>Austrian Science Fund (FWF)</name>
				<originalname>Fonds zur Förderung der Wissenschaftlichen Forschung</originalname>
				<jurisdiction>AT</jurisdiction>
			</funder>
			<xsl:if test="string-length($fundingCode) &gt; 0">
				<funding_level_0>
					<id>
						<xsl:value-of select="concat($funderID, '::', $fundingCode)"/>
					</id>
					<description>
						<xsl:value-of select="$fundingName"/>
					</description>
					<name>
						<xsl:value-of select="$fundingName"/>
					</name>
					<parent></parent>
					<class>fwf:programmes</class>
				</funding_level_0>
			</xsl:if>
		</fundingtree>

	</xsl:template>

</xsl:stylesheet>