/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.openaireplus.api.RecentPublicationsQueue;
import eu.dnetlib.msro.openaireplus.utils.OafToIndexRecordFactory;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;

public class FeedMissingClaimsJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(FeedMissingClaimsJobNode.class);
    private RecentPublicationsQueue queue;
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Value(value="${openaireplus.msro.api.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;

    protected String execute(NodeToken nodeToken) throws Exception {
        String format = nodeToken.getEnv().hasAttribute("format") ? nodeToken.getEnv().getAttribute("format") : nodeToken.getFullEnv().getAttribute("format");
        String coll = format + "-index-openaire";
        String indexDsId = nodeToken.getEnv().getAttribute("index_id");
        String baseUrl = this.calculateIndexBaseUrl();
        try (CloudIndexClient idxClient = null;){
            ArrayList<SolrInputDocument> toFeed = new ArrayList<SolrInputDocument>();
            ArrayList<String> toDeleteFromCache = new ArrayList<String>();
            SAXReader reader = new SAXReader();
            ApplyXslt xslt = this.oafToIndexRecordFactory.newTransformer(format);
            idxClient = CloudIndexClientFactory.newIndexClient((String)baseUrl, (String)coll, (boolean)false);
            for (String record : this.queue) {
                String id = reader.read((Reader)new StringReader(record)).valueOf("//*[local-name() = 'objIdentifier']");
                if (idxClient.isRecordIndexed(id)) {
                    toFeed.add(idxClient.prepareSolrDocument(record, indexDsId, (UnaryFunction)xslt));
                    continue;
                }
                toDeleteFromCache.add(id);
            }
            idxClient.feed(toFeed, null);
            this.queue.remove(toDeleteFromCache);
        }
        return Arc.DEFAULT_ARC;
    }

    public RecentPublicationsQueue getQueue() {
        return this.queue;
    }

    @Required
    public void setQueue(RecentPublicationsQueue queue) {
        this.queue = queue;
    }

    public OafToIndexRecordFactory getOafToIndexRecordFactory() {
        return this.oafToIndexRecordFactory;
    }

    @Required
    public void setOafToIndexRecordFactory(OafToIndexRecordFactory oafToIndexRecordFactory) {
        this.oafToIndexRecordFactory = oafToIndexRecordFactory;
    }

    private String calculateIndexBaseUrl() throws Exception {
        String query = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
    }

    private class CreateSolrDocument
    implements Function<String, SolrInputDocument> {
        private final CloudIndexClient idxClient;
        private final String indexDsId;
        private final UnaryFunction<String, String> toIndexRecord;

        public CreateSolrDocument(CloudIndexClient idxClient, String indexDsId, UnaryFunction<String, String> toIndexRecord) {
            this.idxClient = idxClient;
            this.indexDsId = indexDsId;
            this.toIndexRecord = toIndexRecord;
        }

        public SolrInputDocument apply(String s) {
            try {
                return this.idxClient.prepareSolrDocument(s, this.indexDsId, this.toIndexRecord);
            }
            catch (CloudIndexClientException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class IsNotIndexed
    implements Predicate<String> {
        private final CloudIndexClient idxClient;
        private final SAXReader reader = new SAXReader();

        public IsNotIndexed(CloudIndexClient idxClient) {
            this.idxClient = idxClient;
        }

        public boolean apply(String s) {
            try {
                String id = this.reader.read((Reader)new StringReader(s)).valueOf("//*[local-name() = 'objIdentifier']");
                return !this.idxClient.isRecordIndexed(id);
            }
            catch (Throwable e) {
                log.error((Object)("Error searching record: " + s), e);
                throw new RuntimeException(e);
            }
        }
    }
}

