package eu.dnetlib.utils.ontologies;

import javax.annotation.PostConstruct;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by claudio on 12/12/2016.
 */
@Component
public class OntologyLoader {

	private static UniqueServiceLocator staticServiceLocator;

	@Autowired
	private UniqueServiceLocator serviceLocator;

// <TERM code="merges" encoding="organizationOrganization_dedup_merges" english_name="merges" native_name="merges">
	public static String fetchInverse(final String relType) throws ISLookUpException {
		final String xquery = "let $x:= /RESOURCE_PROFILE["
				+ " .//RESOURCE_TYPE/@value = 'OntologyDSResourceType' and "
				+ " .//TERM/@encoding='"+relType+"']"
				+ "let $y:= $x//TERM[./@encoding='"+relType+"']//RELATION[./@type='inverseOf']/@code/string() "
				+ "return $x//TERM[./@code = $y]/@encoding/string()";
		return staticServiceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xquery);
	}

	@PostConstruct
	public void init() {
		OntologyLoader.staticServiceLocator = serviceLocator;
	}

}