<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="xs" version="1.0">

    <xsl:param name="parentDatasourceId" />
    <xsl:param name="namespacePrefix" />

    <xsl:template match="/">

        <xsl:variable name="funderId" select="string('taraexp_____::tara')" />

        <record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

            <xsl:copy-of select=".//*[local-name()='header']" />

            <metadata>
                <ROWS>
                    <xsl:variable name="projectId" select="concat($namespacePrefix, '::',  normalize-space(.//column[@name='PROJECT ID']))" />
                    <xsl:variable name="startDate" select=".//column[@name='START DATE']" />
                    <xsl:variable name="endDate" select=".//column[@name='END DATE']" />

                    <ROW table="projects">
                        <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
                        <FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
                        <FIELD name="code"><xsl:value-of select=".//column[@name='PROJECT ID']" /></FIELD>
                        <FIELD name="title"><xsl:value-of select=".//column[@name='PROJECT TITLE']" /></FIELD>
                        <FIELD name="jsonextrainfo"><xsl:value-of select=".//column[@name='DM KEYWORDS']" /></FIELD>
                        <FIELD name="startdate" type="date" format="yyyy"><xsl:value-of select="$startDate" /></FIELD>
                        <FIELD name="enddate" type="date" format="yyyy"><xsl:value-of select="$endDate" /></FIELD>
                        <FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
                        <FIELD name="provenanceactionclass">sysimport:crosswalk:entityregistry</FIELD>
                    </ROW>

                    <ROW table="project_fundingpath">
                        <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($funderId, '@@', $projectId)" /></FIELD>
                        <FIELD name="funding"><xsl:value-of select="$funderId" /></FIELD>
                        <FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
                        <FIELD name="startdate" type="date" format="yyyy"><xsl:value-of select="$startDate" /></FIELD>
                        <FIELD name="enddate" type="date" format="yyyy"><xsl:value-of select="$endDate" /></FIELD>
                    </ROW>

                </ROWS>
            </metadata>
        </record>
    </xsl:template>

</xsl:stylesheet>
