/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public class FindComplianceRepositoriesJobNode
extends SimpleJobNode {
    private String dbName;
    private final org.springframework.core.io.Resource sqlSelectDatasourcesTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/getDatasources.sql.st");
    private final org.springframework.core.io.Resource xsltFile = new ClassPathResource("/eu/dnetlib/enabling/datasources/repo_2_is.xslt");
    private String eprParam = "repoEpr";
    @Resource
    private UniqueServiceLocator serviceLocator;
    private XSLTMappedResultSetFactory xsltMappedResultSetFactory;
    private static final Log log = LogFactory.getLog(FindComplianceRepositoriesJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.sqlSelectDatasourcesTmpl.getInputStream()));
        String sql = st.toString();
        String xslt = IOUtils.toString((InputStream)this.xsltFile.getInputStream());
        log.debug((Object)("Executing query: " + sql));
        W3CEndpointReference epr = ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.dbName, sql);
        W3CEndpointReference mapped = this.xsltMappedResultSetFactory.createMappedResultSet(epr, xslt);
        token.getEnv().setTransientAttribute(this.getEprParam(), (Object)mapped);
        return Arc.DEFAULT_ARC;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
        return this.xsltMappedResultSetFactory;
    }

    public void setXsltMappedResultSetFactory(XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
        this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

