<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:utils="eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions"
>

    <xsl:param name="parentDatasourceId"/>
    <xsl:param name="namespacePrefix"/>

    <xsl:variable name="dateFormat" select="string('mm-DD-yyyy')"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::CONICYT')"/>
    <xsl:variable name="fundingId">
        <xsl:value-of select="concat($funderID,'::',.//column[@name='FUNDER STREAM LEVEL I'],'::',.//column[@name='FUNDER STREAM LEVEL II'])"/>
    </xsl:variable>


    <xsl:template match="/">
        <record
        >

            <xsl:copy-of select=".//*[local-name()='header']"/>

            <metadata>
                <ROWS>
                    <xsl:variable name="projectId" select="concat($namespacePrefix, '::',  normalize-space(.//column[@name='PROJECT IDENTIFIER']))"/>
                    <xsl:variable name="startDate" select="replace(.//column[@name='START DATE'],'/','-')"/>

                    <xsl:variable name="endDate" select="replace(.//column[@name='END DATE'],'/','-')"/>

                    <ROW table="projects">

                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <FIELD name="id">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <FIELD name="code">
                            <xsl:value-of select=".//column[@name='PROJECT IDENTIFIER']"/>
                        </FIELD>
                        <FIELD name="title">
                            <xsl:value-of select=".//column[@name='PROJECT TITLE']"/>
                        </FIELD>
                        <FIELD name="startdate" type="date" format="{$dateFormat}">
                            <xsl:value-of select="$startDate"/>
                        </FIELD>

                        <FIELD name="enddate" type="date" format="{$dateFormat}">
                            <xsl:value-of select="$endDate"/>
                        </FIELD>
                        <FIELD name="websiteurl">
                            <xsl:value-of select=".//column[@name='URL DE INFORME FINAL']"/>
                        </FIELD>
                        <FIELD name="collectedfrom">
                            <xsl:value-of select="$parentDatasourceId"/>
                        </FIELD>
                        <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                        <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>


                        <FIELD name="oa_mandate_for_publications" type="boolean">false</FIELD>
                    </ROW>

                    <xsl:variable name="personId">
                        <xsl:variable name="tmp">
                            <xsl:value-of select="concat(.//column[@name='DIRECTOR Apellido1'],.//column[@name='DIRECTOR Apellido2'],.//column[@name='DIRECTOR Nombre'])"/>
                        </xsl:variable>
                        <xsl:value-of select="concat($namespacePrefix,'::',utils:md5($tmp))"/>
                    </xsl:variable>
                    <xsl:if test="not($personId = '')">
                        <ROW table="persons">
                            <FIELD name="_dnet_resource_identifier_">
                                <xsl:value-of select="$personId"/>
                            </FIELD>
                            <FIELD name="id">
                                <xsl:value-of select="$personId"/>
                            </FIELD>
                            <xsl:if test="not(.//column[@name='DIRECTOR Nombre'] = '')">
                                <FIELD name="firstname">
                                    <xsl:value-of select=".//column[@name='DIRECTOR Nombre']"/>
                                </FIELD>
                            </xsl:if>

                            <FIELD name="secondnames">
                                <xsl:value-of select="concat(.//column[@name='DIRECTOR Apellido1'],' ' ,.//column[@name='DIRECTOR Apellido2'])"/>
                            </FIELD>

                            <FIELD name="collectedfrom">
                                <xsl:value-of select="$parentDatasourceId"/>
                            </FIELD>
                            <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                            <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                        </ROW>
                    </xsl:if>

                    <xsl:for-each select="tokenize(.//column[@name='PARTICIPANT INSTITUTIONS2'],';')">
                        <xsl:variable name="organizationId" select="concat($namespacePrefix,'::',utils:md5(normalize-space(.)))"/>
                        <ROW table = "organizations">
                            <FIELD name="_dnet_resource_identifier_">
                                <xsl:value-of select="$organizationId"/>
                            </FIELD>
                            <FIELD name="id">
                                <xsl:value-of select="$organizationId"/>
                            </FIELD>
                            <FIELD name="legalshortname">
                                <xsl:value-of select="normalize-space(.)"/>
                            </FIELD>
                            <FIELD name="collectedfrom">
                                <xsl:value-of select="$parentDatasourceId"/>
                            </FIELD>
                            <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                            <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                        </ROW>
                        <ROW table="project_organization">
                            <FIELD name="_dnet_resource_identifier_">
                                <xsl:value-of select='concat($projectId, "@@", $organizationId)'/>
                            </FIELD>
                            <FIELD name="project">
                                <xsl:value-of select="$projectId"/>
                            </FIELD>
                            <FIELD name="resporganization">
                                <xsl:value-of select="$organizationId"/>
                            </FIELD>

                            <xsl:choose>

                                <xsl:when test="not($personId = '') and position() = 1">
                                    <FIELD name="contactperson">
                                        <xsl:value-of select="$personId"/>
                                    </FIELD>
                                </xsl:when>
                                <xsl:otherwise>
                                    <FIELD name="contactperson"/>
                                </xsl:otherwise>
                            </xsl:choose>


                            <FIELD name="semanticclass">participant</FIELD>
                            <FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
                        </ROW>
                    </xsl:for-each>

                    <ROW table="project_fundingpath">
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="concat($fundingId, '@@', $projectId)"/>
                        </FIELD>
                        <FIELD name="funding">
                            <xsl:value-of select="$fundingId"/>
                        </FIELD>
                        <FIELD name="project">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <FIELD name="startdate" type="date" format="{$dateFormat}">
                            <xsl:value-of select="$startDate"/>
                        </FIELD>

                        <FIELD name="enddate" type="date" format="{$dateFormat}">
                            <xsl:value-of select="$endDate"/>
                        </FIELD>
                    </ROW>
                </ROWS>
            </metadata>
        </record>
    </xsl:template>
</xsl:stylesheet>
