/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.msro.openaireplus.workflows.nodes.claims.AbstractClaimsToHBASE;
import eu.dnetlib.msro.openaireplus.workflows.nodes.claims.Claim;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.utils.ontologies.OntologyLoader;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

public class ApplyClaimRelsJobNode
extends AbstractClaimsToHBASE {
    private static final Log log = LogFactory.getLog(ApplyClaimRelsJobNode.class);
    private final String SEPARATOR = "_";

    protected String execute(NodeToken token) throws Exception {
        long timestamp = System.currentTimeMillis();
        this.setTotal(this.getClaimDatabaseUtils().count(this.getCountQuery()));
        List<Claim> claimRels = this.getClaimDatabaseUtils().query(this.getSql());
        int totalWrites = 0;
        int valid = 0;
        int discardedClaims = 0;
        HadoopService hadoopService = (HadoopService)this.getServiceLocator().getService(HadoopService.class);
        for (Claim claim : claimRels) {
            log.debug((Object)claim);
            try {
                String sourceId = this.getFullId(this.getOpenAIREType(claim.getSourceType()), claim.getSource());
                String targetId = this.getFullId(this.getOpenAIREType(claim.getTargetType()), claim.getTarget());
                String value = this.getValue(sourceId, claim.getSemantics(), targetId, timestamp);
                hadoopService.addHBaseColumn(this.getClusterName(), this.getTableName(), sourceId, claim.getSemantics(), targetId, value);
                ++totalWrites;
                String inverseSemantics = OntologyLoader.fetchInverse(claim.getSemantics());
                String inverseValue = this.getValue(targetId, inverseSemantics, sourceId, timestamp);
                hadoopService.addHBaseColumn(this.getClusterName(), this.getTableName(), targetId, inverseSemantics, sourceId, inverseValue);
                ++totalWrites;
                this.incrementProcessed();
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Discarding claim " + claim + ". Cause: " + e.getMessage()));
                ++discardedClaims;
            }
        }
        log.info((Object)("totalClaimRels: " + this.getTotal()));
        token.getEnv().setAttribute("claimRelsSize", (Object)this.getTotal());
        log.info((Object)("claim rels writeOps: " + totalWrites));
        token.getEnv().setAttribute("claimRelsWriteOps", (Object)totalWrites);
        log.info((Object)("validClaimRels: " + valid));
        token.getEnv().setAttribute("validClaimRels", (Object)valid);
        log.info((Object)("discardedClaimRels: " + discardedClaims));
        token.getEnv().setAttribute("discardedClaimRels", (Object)discardedClaims);
        return Arc.DEFAULT_ARC;
    }

    protected String getValue(String sourceId, String semantics, String targetId, long timestamp) throws MSROException {
        log.debug((Object)StringUtils.format((String)"%s -- %s -- %s", (Object[])new Object[]{sourceId, semantics, targetId}));
        String[] relInfo = semantics.split("_");
        if (relInfo.length < 3) {
            throw new MSROException("Semantics " + semantics + " not supported: must be splittable in 3 by '_'");
        }
        FieldTypeProtos.Qualifier.Builder semanticsBuilder = FieldTypeProtos.Qualifier.newBuilder().setClassid(relInfo[2]).setClassname(relInfo[2]);
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setLastupdatetimestamp(timestamp);
        builder.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setTrust("0.91").setInferred(false).setProvenanceaction(FieldTypeProtos.Qualifier.newBuilder().setClassid("user:claim").setClassname("user:claim").setSchemeid("dnet:provenanceActions").setSchemename("dnet:provenanceActions")));
        RelTypeProtos.SubRelType subRelType = RelTypeProtos.SubRelType.valueOf((String)relInfo[1]);
        OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder().setSubRelType(subRelType).setRelClass(relInfo[2]).setRelType(RelTypeProtos.RelType.valueOf((String)relInfo[0])).setSource(sourceId).setTarget(targetId).setChild(false);
        switch (relInfo[0]) {
            case "resultProject": {
                relBuilder.setResultProject(ResultProjectProtos.ResultProject.newBuilder().setOutcome(ResultProjectProtos.ResultProject.Outcome.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(semanticsBuilder.setSchemeid("dnet:result_project_relations").setSchemename("dnet:result_project_relations").build()))));
                break;
            }
            case "resultResult": {
                relBuilder.setResultResult(ResultResultProtos.ResultResult.newBuilder().setPublicationDataset(ResultResultProtos.ResultResult.PublicationDataset.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(semanticsBuilder.setSchemeid("dnet:result_result_relations").setSchemename("dnet:result_result_relations").build()))));
                break;
            }
            default: {
                throw new MSROException("Semantics " + relInfo[0] + " not supported");
            }
        }
        builder.setRel(relBuilder);
        return Base64.encodeBase64String((byte[])builder.build().toByteArray());
    }
}

