<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:clean="eu.dnetlib.msro.openaireplus.utils.CleaningXsltFunctions"
                version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">

		<record
		>

			<xsl:copy-of select=".//*[local-name()='header']"/>

			<metadata>
				<ROWS>
					<xsl:variable name="setSpec" select=".//*[local-name()='setSpec']"/>
					<xsl:variable name="setName" select=".//*[local-name()='setName']"/>

					<xsl:variable name="id" select="concat($namespacePrefix,'::', $setSpec)"/>

					<ROW table="datacite_temp_sets">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$id"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$id"/>
						</FIELD>
						<FIELD name="setname">
							<xsl:value-of select="$setName"/>
						</FIELD>
						<FIELD name="setspec">
							<xsl:value-of select="$setSpec"/>
						</FIELD>
						<FIELD name="setname_cleaned">
							<xsl:value-of select="clean:clean($setName)"/>
						</FIELD>
						<FIELD name="oa_source_id">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
					</ROW>
				</ROWS>
			</metadata>
		</record>

	</xsl:template>
</xsl:stylesheet>
