<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

	<xsl:param name="parentDatasourceId"/>

	<xsl:template name="dateCorda">
		<xsl:param name="datename"/>
		<xsl:param name="datevalue"/>
		<FIELD name="{$datename}" type="date" format="dd-MMM-yyyy">
			<xsl:value-of select="concat(substring($datevalue, 1, 2),'-',substring($datevalue,3,3),'-',substring($datevalue,6,4))"/>
		</FIELD>
	</xsl:template>

	<xsl:variable name="namespacePrefix" select="string('ec__________')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::EC')"/>

	<xsl:template match="/">
		<record
		>

			<xsl:copy-of select=".//*[local-name()='header']"/>

			<metadata>
				<ROWS>
					<xsl:for-each select="//Project">

						<xsl:variable name="fundingId" select="concat($funderID, '::H2020')"/>
						<xsl:variable name="projectId" select="concat('corda__h2020::', normalize-space(./ProjectId))"/>

						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$projectId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$projectId"/>
							</FIELD>
							<FIELD name="code">
								<xsl:value-of select="./ProjectId"/>
							</FIELD>
							<FIELD name="acronym">
								<xsl:value-of select="./ProjectAcronym"/>
							</FIELD>
							<FIELD name="title">
								<xsl:value-of select="./ProjectTitle"/>
							</FIELD>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">startdate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectStartDate"></xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">enddate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectEndDate"></xsl:with-param>
							</xsl:call-template>
							<FIELD name="call_identifier">
								<xsl:value-of select="./ProjectCallIdentifier"/>
							</FIELD>
							<FIELD name="oa_mandate_for_publications" type="boolean">true</FIELD>
							<FIELD name="ec_article29_3" type="boolean">
								<xsl:value-of select="./Article29-3"/>
							</FIELD>
							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>
							<FIELD name="contracttypeclass">
								<xsl:value-of select="./ProjectTOACode"/>
							</FIELD>
							<FIELD name="contracttypescheme">ec:h2020toas</FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="websiteurl">
								<xsl:value-of select="./ProjectInternetAddress"/>
							</FIELD>
							<FIELD name="optional1">
								<xsl:value-of select="./ProjectTopicCode"/>
							</FIELD>
							<FIELD name="optional2">
								<xsl:value-of select="./ProjectTopicDescr"/>
							</FIELD>
							<xsl:variable name="personSurname" select="./CoordinatorContactPerson/PersonLastName"/>
							<xsl:variable name="personFirstName" select="./CoordinatorContactPerson/PersonFirstName"/>
							<xsl:variable name="contactfullname">
								<xsl:choose>
									<xsl:when test="string-length($personFirstName) &gt; 0 and string-length($personSurname) &gt; 0">
										<xsl:value-of select="normalize-space(concat($personSurname, ', ', $personFirstName))"/>
									</xsl:when>
									<xsl:when test="string-length($personFirstName) &gt; 0">
										<xsl:value-of select="normalize-space($personFirstName)"/>
									</xsl:when>
									<xsl:when test="string-length($personSurname) &gt; 0">
										<xsl:value-of select="normalize-space($personSurname)"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="''"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:if test="string-length($contactfullname) &gt; 0">
								<FIELD name="contactfullname">
									<xsl:value-of select="$contactfullname"/>
								</FIELD>
							</xsl:if>
							<xsl:variable name="contactfax" select="normalize-space(./CoordinatorContactPerson/ContactFax)"/>
							<xsl:if test="string-length($contactfax) &gt; 0">
								<FIELD name="contactfax">
									<xsl:value-of select="$contactfax"/>
								</FIELD>
							</xsl:if>
							<xsl:variable name="contactphone" select="normalize-space(./CoordinatorContactPerson/ContactPhone)"/>
							<xsl:if test="string-length($contactphone) &gt; 0">
								<FIELD name="contactphone">
									<xsl:value-of select="$contactphone"/>
								</FIELD>
							</xsl:if>
							<xsl:variable name="contactemail" select="normalize-space(./CoordinatorContactPerson/ContactEmail)"/>
							<xsl:if test="string-length($contactemail) &gt; 0">
								<FIELD name="contactemail">
									<xsl:value-of select="$contactemail"/>
								</FIELD>
							</xsl:if>
						</ROW>

						<xsl:for-each select="./OrganisationParticipant">
							<xsl:variable name="organizationId" select="concat('corda__h2020::', ./OrganisationPIC)"/>

							<xsl:variable name="whitelist" select="'0123456789'"/>
							<ROW table="organizations">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="$organizationId"/>
								</FIELD>
								<FIELD name="id">
									<xsl:value-of select="$organizationId"/>
								</FIELD>
								<FIELD name="legalshortname">
									<xsl:value-of select="./OrganisationShortName"/>
								</FIELD>
								<FIELD name="legalname">
									<xsl:value-of select="./OrganisationLegalName"/>
								</FIELD>
								<FIELD name="websiteurl">
									<xsl:choose>
										<xsl:when test="starts-with(normalize-space(./OrganisationWebPage), 'http')">
											<xsl:value-of select="./OrganisationWebPage"/>
										</xsl:when>
										<xsl:when test="string-length(normalize-space(./OrganisationWebPage)) &gt; 0">
											<xsl:value-of select="concat('http://', normalize-space(./OrganisationWebPage))"/>
										</xsl:when>
									</xsl:choose>
								</FIELD>
								<FIELD name="ec_legalbody" type="boolean">
									<xsl:value-of select="./PublicBody"/>
								</FIELD>
								<FIELD name="ec_legalperson" type="boolean">
									<xsl:value-of select="./LegalPerson"/>
								</FIELD>
								<FIELD name="ec_nonprofit" type="boolean">
									<xsl:value-of select="./NonProfit"/>
								</FIELD>
								<FIELD name="ec_researchorganization" type="boolean">
									<xsl:value-of select="./ResearchOrganisation"/>
								</FIELD>
								<FIELD name="ec_highereducation" type="boolean">
									<xsl:value-of select="./HigherEducation"/>
								</FIELD>
								<FIELD name="ec_internationalorganizationeurinterests" type="boolean">
									<xsl:value-of select="./InternationalOrgEurInterest"/>
								</FIELD>
								<FIELD name="ec_internationalorganization" type="boolean">
									<xsl:value-of select="./InternationalOrgEurInterest"/>
								</FIELD>
								<FIELD name="ec_smevalidated" type="boolean">
									<xsl:value-of select="./SMEValidated"/>
								</FIELD>
								<FIELD name="countryclass">
									<xsl:value-of select="./OrganisationCountry"/>
								</FIELD>
								<FIELD name="countryscheme">dnet:countries</FIELD>
								<FIELD name="collectedfrom">
									<xsl:value-of select="$parentDatasourceId"/>
								</FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
								<FIELD name="trust" type="float">
									<xsl:value-of select="0.92"/>
								</FIELD>
							</ROW>

							<ROW table="project_organization">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select='concat($projectId, "@@", $organizationId)'/>
								</FIELD>
								<xsl:choose>
									<xsl:when test="string-length(translate(./ParticipantOrder, $whitelist, '')) &gt; 0">
										<FIELD name="participantnumber" type="int">9999</FIELD>
									</xsl:when>
									<xsl:otherwise>
										<FIELD name="participantnumber" type="int">
											<xsl:value-of select="./ParticipantOrder"/>
										</FIELD>
									</xsl:otherwise>
								</xsl:choose>
								<FIELD name="project">
									<xsl:value-of select="$projectId"/>
								</FIELD>
								<FIELD name="resporganization">
									<xsl:value-of select="$organizationId"/>
								</FIELD>
								<xsl:choose>
									<xsl:when test="./ParticipantOrder = 1">
										<FIELD name="semanticclass">coordinator</FIELD>
									</xsl:when>
									<xsl:otherwise>
										<FIELD name="semanticclass">participant</FIELD>
									</xsl:otherwise>
								</xsl:choose>
								<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
							</ROW>
						</xsl:for-each>

						<ROW table="subjects">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat('corda__h2020::', normalize-space(./ProjectTopicCode))"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="concat('corda__h2020::', normalize-space(./ProjectTopicCode))"/>
							</FIELD>
							<FIELD name="name">
								<xsl:value-of select="./ProjectTopicDescr"/>
							</FIELD>
							<FIELD name="semanticclass">ec:h2020topics</FIELD>
							<FIELD name="semanticscheme">dnet:subject_classification_typologies</FIELD>
						</ROW>

						<ROW table="project_subject">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($projectId, '@@corda__h2020::', normalize-space(./ProjectTopicCode))"/>
							</FIELD>
							<FIELD name="project">
								<xsl:value-of select="$projectId"/>
							</FIELD>
							<FIELD name="subject">
								<xsl:value-of select="concat('corda__h2020::', normalize-space(./ProjectTopicCode))"/>
							</FIELD>
						</ROW>

						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($fundingId, '@@', $projectId)"/>
							</FIELD>
							<FIELD name="funding">
								<xsl:value-of select="$fundingId"/>
							</FIELD>
							<FIELD name="project">
								<xsl:value-of select="$projectId"/>
							</FIELD>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">startdate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectStartDate"></xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">enddate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectEndDate"></xsl:with-param>
							</xsl:call-template>
							<FIELD name="semanticclass">
								<xsl:value-of select="./ProjectTOACode"/>
							</FIELD>
							<FIELD name="semanticscheme">ec:h2020toas</FIELD>
						</ROW>
					</xsl:for-each>

				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
