<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:stringUtils="org.apache.commons.lang.StringUtils"
                version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">
		<record
		>

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<xsl:variable name="rid" select="normalize-space(//column[./@name='ISSN'])"/>
				<xsl:variable name="datasourceId" select="concat($namespacePrefix, '::', $rid)"/>
				<xsl:variable name="ISSNNS" select="stringUtils:replace($rid,'-','')"/>
				<xsl:variable name="oName" select="normalize-space(//column[./@name='Title'])"/>
				<xsl:variable name="organizationId"
				              select="translate(concat($namespacePrefix, '::', $oName), ' ', '_')"/>
				<ROWS>
					<ROW table="datasources">
						<FIELD name="id">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="officialname">
							<xsl:value-of select="normalize-space(//column[./@name='Title'])"/>
						</FIELD>
						<FIELD name="englishname">
							<xsl:value-of select="normalize-space(//column[./@name='Title'])"/>
						</FIELD>
						<FIELD name="od_contenttypes">
							<xsl:value-of select="string('Journal articles')"/>
						</FIELD>
						<FIELD name="od_languages">
							<xsl:value-of select="normalize-space(//column[./@name='Language'])"/>
						</FIELD>
						<FIELD name="issn">
							<xsl:value-of select="normalize-space(//column[./@name='ISSN'])"/>
						</FIELD>
						<FIELD name="eissn">
							<xsl:value-of select="normalize-space(//column[./@name='EISSN'])"/>
						</FIELD>
						<FIELD name="description">
							<xsl:value-of select="normalize-space(//column[./@name='Keyword'])"/>
						</FIELD>
						<FIELD name="websiteurl">
							<xsl:value-of select="normalize-space(//column[./@name='address'])"/>
						</FIELD>
						<FIELD name="namespaceprefix">
							<xsl:value-of select="concat('ojs_', $ISSNNS)"/>
						</FIELD>
						<FIELD name="datasourceclass">pubsrepository::journal</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
					</ROW>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
