<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" version="2.0" exclude-result-prefixes="fn">

    <xsl:param name="parentDatasourceId"/>
    <xsl:param name="namespacePrefix"/>
    <xsl:template name="FirstLetterAndNumber">
        <xsl:param name="string" select="normalize-space(translate(., ', ', ' '))"/>

        <xsl:for-each select="tokenize($string, ' ')">
            <xsl:if test="string-length(.) != 0">
                <xsl:variable name="char" select="substring(., 1, 1)"/>
                <xsl:if test="fn:upper-case($char)=$char">
                    <xsl:value-of select="$char"/>
                </xsl:if>

            </xsl:if>
        </xsl:for-each>
    </xsl:template>


    <xsl:template match="/">

        <xsl:variable name="funderId" select="concat($namespacePrefix, '::SGOV')"/>
        <xsl:variable name="dateFormat" select="string('mm/DD/yyyy')"/>
        <xsl:variable name="stream">
            <xsl:call-template name="FirstLetterAndNumber">
                <xsl:with-param name="string" select=".//column[@name = 'Entidad Convocante']"/>
            </xsl:call-template>

        </xsl:variable>
        <xsl:variable name="streaml1">
            <xsl:call-template name="FirstLetterAndNumber">
                <xsl:with-param name="string" select=".//column[@name = 'Unidad Directiva']"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="fundingId">
            <xsl:choose>
                <xsl:when test="string-length($stream) &gt; 0">
                    <xsl:choose>
                        <xsl:when test="string-length($streaml1) &gt; 0">
                            <xsl:value-of select="concat($funderId, '::', $stream, '::', $streaml1)"
                            />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="concat($funderId, '::', $stream)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$funderId"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>


        <record>

            <xsl:copy-of select=".//*[local-name() = 'header']"/>

            <metadata>
                <ROWS>
                    <xsl:variable name="projectId"
                                  select="concat($namespacePrefix, '::', normalize-space(.//column[@name = 'Referencia Proyecto']))"/>
                    <xsl:variable name="startDate" select=".//column[@name = 'fecha convocatoria']"/>
                    <xsl:variable name="endDate" select=".//column[@name = 'fecha resolucion']"/>

                    <ROW table="projects">
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <FIELD name="id">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <FIELD name="code">
                            <xsl:value-of select=".//column[@name = 'Referencia Proyecto']"/>
                        </FIELD>
                        <FIELD name="title">
                            <xsl:value-of select=".//column[@name = 'Título Proyecto']"/>
                        </FIELD>

                        <xsl:if test="not($startDate = 'abierta')">
                            <FIELD name="startdate" type="date" format="{$dateFormat}">
                                <xsl:value-of select="$startDate"/>
                            </FIELD>
                        </xsl:if>
                        <xsl:if test="not($endDate = 'abierta')">
                            <FIELD name="enddate" type="date" format="{$dateFormat}">
                                <xsl:value-of select="$endDate"/>
                            </FIELD>
                        </xsl:if>
                        <FIELD name="collectedfrom">
                            <xsl:value-of select="$parentDatasourceId"/>
                        </FIELD>
                        <FIELD name="provenanceActionClass"
                        >sysimport:crosswalk:entityregistry</FIELD>
                        <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                        <FIELD name="collectedfrom">
                            <xsl:value-of select="$parentDatasourceId"/>
                        </FIELD>

                        <FIELD name="oa_mandate_for_publications" type="boolean">false</FIELD>
                    </ROW>

                    <ROW table="project_fundingpath">
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="concat($fundingId, '@@', $projectId)"/>
                        </FIELD>
                        <FIELD name="funding">
                            <xsl:value-of select="$fundingId"/>
                        </FIELD>
                        <FIELD name="project">
                            <xsl:value-of select="$projectId"/>
                        </FIELD>
                        <xsl:if test="not($startDate = 'abierta')">
                            <FIELD name="startdate" type="date" format="{$dateFormat}">
                                <xsl:value-of select="$startDate"/>
                            </FIELD>
                        </xsl:if>
                        <xsl:if test="not($endDate = 'abierta')">
                            <FIELD name="enddate" type="date" format="{$dateFormat}">
                                <xsl:value-of select="$endDate"/>
                            </FIELD>
                        </xsl:if>

                    </ROW>




                </ROWS>
            </metadata>
        </record>
    </xsl:template>

</xsl:stylesheet>
