<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" version="1.0"
                exclude-result-prefixes="fn" xmlns:utils="eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions">

    <xsl:variable name="namespacePrefix" select="string('dfgf________')"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::DFGF')"/>

    <xsl:template match="/">
        <fundings>
            <fundingtree>
                <funder>
                    <id>
                        <xsl:value-of select="$funderID"/>
                    </id>
                    <shortname>DFG</shortname>
                    <name>Deutsche Forschungsgemeinschaft</name>
                    <jurisdiction>DE</jurisdiction>
                </funder>
                <xsl:variable name="stream" select ="normalize-space(.//column[@name='Funding Programme'])" />
                <xsl:variable name="stream_id" select="utils:md5($stream)"/>
                <xsl:if test="string-length($stream_id) > 0">
                    <funding_level_0>
                        <id>
                            <xsl:value-of select="concat($funderID, '::', $stream_id)"/>
                        </id>

                        <description>
                            <xsl:value-of select="$stream"/>
                        </description>
                        <name>
                            <xsl:value-of select="$stream"/>
                        </name>
                        <parent></parent>
                        <class>dfg:fundingStream</class>
                    </funding_level_0>
                </xsl:if>
            </fundingtree>
        </fundings>
    </xsl:template>

</xsl:stylesheet>