package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import java.util.Map.Entry;
import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpsertHostedByApisJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(UpsertHostedByApisJobNode.class);

	private static final String HOSTED_BY_COMPLIANCE = "hostedBy";

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String countersParam;
	private String mdId;
	public static final String extraFieldsForTotal = "last_aggregation_total";
	public static final String extraFieldForDate = "last_aggregation_date";
	public static final String extraFieldForMdId = "last_aggregation_mdId";

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final HostedByCounters counters = (HostedByCounters) token.getEnv().getTransientAttribute(countersParam);
		final DatasourceManagerService dsManager = serviceLocator.getService(DatasourceManagerService.class);
		final String date = DateUtils.now_ISO8601();
		final String namespacePrefix = token.getEnv().getAttribute("namespacePrefix");

		log.info(counters);

		for (Entry<String, Integer> e : counters.getCounters().entrySet()) {
			updateHostedByApi(dsManager, e.getKey(), namespacePrefix, date, e.getValue());
		}

		return Arc.DEFAULT_ARC;
	}

	private void updateHostedByApi(final DatasourceManagerService dsManager,
			final String dsId,
			final String namepsacePrefix,
			final String date,
			final int size) {
		log.info("Verifying hostedBy api in ds: " + dsId);
		try {
			final DatasourceDesc ds = dsManager.getDatasource(dsId);

			for (IfaceDesc iface : ds.getInterfaces()) {
				if (HOSTED_BY_COMPLIANCE.equals(iface.getCompliance())) {
					return;
				}
			}

			final IfaceDesc iface = new IfaceDesc();
			iface.setId("api_________::" + dsId + "::hostedBy");
			iface.setTypology(ds.getDatasourceClass());
			iface.setCompliance(HOSTED_BY_COMPLIANCE);
			iface.setAccessProtocol("UNKNOWN");
			iface.setContentDescription("metadata");
			iface.setBaseUrl("");
			iface.setActive(false);
			iface.setRemovable(true);
			dsManager.addInterface(dsId, iface);
		} catch (DatasourceManagerServiceException e) {
			log.warn("Error setting hostedBy api of ds: " + dsId, e);
		}
	}

	public String getMdId() {
		return mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getCountersParam() {
		return countersParam;
	}

	public void setCountersParam(final String countersParam) {
		this.countersParam = countersParam;
	}

}
