<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
>

	<xsl:output indent="yes"/>

	<xsl:param name="parentDatasourceId"/>

	<xsl:template match="/">
		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>

			<metadata>
				<ROWS>
					<xsl:variable name="projectId" select="concat('mestd_______::', normalize-space(.//column[./@name='PROJECT IDENTIFIER']))"/>
					<xsl:variable name="fundingId" select="concat('mestd_______::MESTD::', normalize-space(.//column[./@name='FUNDING STREAM(S)']))"/>

					<ROW table="projects">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="code">
							<xsl:value-of select="normalize-space(.//column[./@name='PROJECT IDENTIFIER'])"/>
						</FIELD>
						<FIELD name="title">
							<xsl:value-of select=".//column[./@name='PROJECT TITLE or ACRONYM']"/>
						</FIELD>
						<FIELD name="startdate" type="date" format="yyyy-MM-dd">
							<xsl:value-of select="//column[./@name='START DATE']"/>
						</FIELD>
						<FIELD name="enddate" type="date" format="yyyy-MM-dd">
							<xsl:value-of select="//column[./@name='END DATE']"/>
						</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
					</ROW>

					<ROW table="project_fundingpath">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($fundingId, '@@', $projectId)"/>
						</FIELD>
						<FIELD name="funding">
							<xsl:value-of select="$fundingId"/>
						</FIELD>
						<FIELD name="project">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="startdate" type="date" format="yyyy-MM-dd">
							<xsl:value-of select="//column[./@name='START DATE']"/>
						</FIELD>
						<FIELD name="enddate" type="date" format="yyyy-MM-dd">
							<xsl:value-of select="//column[./@name='END DATE']"/>
						</FIELD>
					</ROW>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
