<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('snsf________')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::SNSF')"/>

	<xsl:template match="/">
		<fundings>
			<xsl:variable name="p0" select="normalize-space(.//column[@name='Funding Instrument Hierarchy'])"/>
			<xsl:variable name="p1" select="normalize-space(.//column[@name='Funding Instrument'])"/>

			<fundingtree>
				<funder>
					<id>
						<xsl:value-of select="$funderID"/>
					</id>
					<shortname>SNSF</shortname>
					<name>Swiss National Science Foundation</name>
					<jurisdiction>CH</jurisdiction>
				</funder>
				<xsl:if test="string-length($p1) &gt; 0">
					<xsl:choose>
						<xsl:when test="(string-length($p0) &gt; 0) and (string-length($p1) &gt; 0)">
							<xsl:variable name="level0" select="concat($funderID, '::', $p0)"/>
							<xsl:variable name="level1" select="concat($funderID, '::', $p0, '::', $p1)"/>
							<funding_level_1>
								<id>
									<xsl:value-of select="$level1"/>
								</id>
								<description>
									<xsl:value-of select="$p1"/>
								</description>
								<name>
									<xsl:value-of select="$p1"/>
								</name>
								<parent>
									<funding_level_0>
										<id>
											<xsl:value-of select="$level0"/>
										</id>
										<description>
											<xsl:value-of select="$p0"/>
										</description>
										<name>
											<xsl:value-of select="$p0"/>
										</name>
										<parent/>
										<class>snsf:fundingStream</class>
									</funding_level_0>
								</parent>
							</funding_level_1>
						</xsl:when>
						<xsl:when test="string-length($p0) &gt; 0">
							<xsl:variable name="level0" select="concat($funderID, '::', $p0)"/>
							<funding_level_0>
								<id>
									<xsl:value-of select="$level0"/>
								</id>
								<description>
									<xsl:value-of select="$p0"/>
								</description>
								<name>
									<xsl:value-of select="$p0"/>
								</name>
								<parent/>
								<class>snsf:fundingStream</class>
							</funding_level_0>
						</xsl:when>
						<xsl:when test="string-length($p1) &gt; 0">
							<xsl:variable name="level0" select="concat($funderID, '::', $p1)"/>
							<funding_level_0>
								<id>
									<xsl:value-of select="$level0"/>
								</id>
								<description>
									<xsl:value-of select="$p1"/>
								</description>
								<name>
									<xsl:value-of select="$p1"/>
								</name>
								<parent/>
								<class>snsf:fundingStream</class>
							</funding_level_0>
						</xsl:when>
						<xsl:otherwise><!-- Funding columns are empty --></xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</fundingtree>
		</fundings>
	</xsl:template>
</xsl:stylesheet>
