package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos.DataInfo;
import eu.dnetlib.data.proto.FieldTypeProtos.Qualifier;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by Alessia Bardi on 28/06/2017.
 *
 * @author Alessia Bardi
 */
public abstract class AbstractClaimsToHBASE extends SimpleJobNode implements ProgressJobNode {

	private static final Log log = LogFactory.getLog(AbstractClaimsToHBASE.class);

	private String sql;
	private String countQuery;

	private int total = 0;
	private int processed = 0;

	private String clusterName;
	private String tableName;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private ClaimDatabaseUtils claimDatabaseUtils;

	@Override
	public ProgressProvider getProgressProvider() {
		return new ProgressProvider() {

			@Override
			public boolean isInaccurate() {
				return false;
			}

			@Override
			public int getTotalValue() {
				return total;
			}

			@Override
			public int getCurrentValue() {
				return processed;
			}
		};
	}

	protected String getOpenAIREType(final String type) {
		switch (type) {
		case "publication":
		case "dataset":
			return "result";
		default:
			return type;
		}
	}

	protected String getFullId(final String type, final String id) {
		final String fullId = AbstractDNetXsltFunctions.oafSimpleId(type, id);
		return OafRowKeyDecoder.decode(fullId).getKey();
	}

	protected static DataInfo getDataInfo() {
		return DataInfo.newBuilder().setTrust("0.91").setInferred(false)
				.setProvenanceaction(
						Qualifier.newBuilder()
								.setClassid("user:claim")
								.setClassname("user:claim")
								.setSchemeid("dnet:provenanceActions")
								.setSchemename("dnet:provenanceActions")).build();

	}

	public String getSql() {
		return sql;
	}

	public void setSql(final String sql) {
		this.sql = sql;
	}

	public String getCountQuery() {
		return countQuery;
	}

	public void setCountQuery(final String countQuery) {
		this.countQuery = countQuery;
	}

	public int getTotal() {
		return total;
	}

	public void setTotal(final int total) {
		this.total = total;
	}

	public int getProcessed() {
		return processed;
	}

	public void setProcessed(final int processed) {
		this.processed = processed;
	}

	public void incrementProcessed() {
		processed++;
	}

	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(final String clusterName) {
		this.clusterName = clusterName;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(final String tableName) {
		this.tableName = tableName;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(final UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public ClaimDatabaseUtils getClaimDatabaseUtils() {
		return claimDatabaseUtils;
	}

	public void setClaimDatabaseUtils(final ClaimDatabaseUtils claimDatabaseUtils) {
		this.claimDatabaseUtils = claimDatabaseUtils;
	}
}
