<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('ec__________')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::EC')"/>

	<xsl:template match="/">
		<fundingtree>
			<funder>
				<id>
					<xsl:value-of select="$funderID"/>
				</id>
				<shortname>EC</shortname>
				<name>European Commission</name>
				<jurisdiction>EU</jurisdiction>
			</funder>
			<funding_level_0>
				<id>
					<xsl:value-of select="concat($funderID, '::H2020')"/>
				</id>
				<name>H2020</name>
				<description>Horizon 2020 Framework Programme</description>
				<parent/>
				<class>ec:h2020fundings</class>
			</funding_level_0>
		</fundingtree>
	</xsl:template>

</xsl:stylesheet>
