package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import java.io.StringReader;
import java.util.List;
import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class SaveContextProfileJobNode extends SimpleJobNode {

	private String contextObj;

	private static final Log log = LogFactory.getLog(SaveContextProfileJobNode.class);

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final ContextDesc desc = (ContextDesc) token.getEnv().getTransientAttribute(getContextObj());

		final String xquery = "for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType') " + "where $x//CONFIGURATION/context[@id='"
				+ desc.getId() + "' " + "and @type='" + desc.getType() + "'] " + "return $x";
		List<String> list = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);

		if (list.isEmpty()) {
			registerNewProfile(desc);
		} else {
			updateProfile(list.get(0), desc);
		}

		return Arc.DEFAULT_ARC;
	}

	private void updateProfile(final String profile, final ContextDesc desc) throws DocumentException, ISRegistryException {
		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(new StringReader(profile));
		final String profId = doc.valueOf("//HEADER/RESOURCE_IDENTIFIER/@value");
		final Element ctxElem = (Element) doc.selectSingleNode("//CONFIGURATION/context[@id='" + desc.getId() + "' and @type='" + desc.getType() + "']");
		updateContextParams(ctxElem, desc);

		for (ContextPart cat : desc.getCategories().values()) {
			final Node catElem = ctxElem.selectSingleNode("./category[@id='" + cat.getId() + "']");
			if (catElem != null) {
				catElem.detach();
			}
			ctxElem.add(cat.asDomElement("category"));
		}
		log.info("registering profile context " + desc.getId());
		serviceLocator.getService(ISRegistryService.class).updateProfile(profId, doc.asXML(), "ContextDSResourceType");
	}

	private void updateContextParams(final Element ctxElement, ContextDesc desc) {
		//removing old PARAMs
		List oldParams = ctxElement.selectNodes("param");
		for (Object o : oldParams) {
			Node n = (Node) o;
			n.detach();
		}
		//adding new params
		for (Element param : desc.getParamsAsElements()) {
			ctxElement.add(param);
		}
	}

	private void registerNewProfile(final ContextDesc desc) throws DocumentException, ISRegistryException {
		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(getClass().getResourceAsStream(
				"/eu/dnetlib/msro/openaireplus/workflows/repo-hi/entityreg-contexts/xml/contextProfile.xml"));
		((Element) doc.selectSingleNode("//CONFIGURATION")).add(desc.asDomElement());
		log.info("updating profile context " + desc.getId());
		serviceLocator.getService(ISRegistryService.class).registerProfile(doc.asXML());
	}

	public String getContextObj() {
		return contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

}
