/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.index.client.solr.SolrIndexClient;
import eu.dnetlib.functionality.index.client.solr.SolrIndexClientFactory;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.openaireplus.api.RecentResultsQueue;
import eu.dnetlib.msro.openaireplus.utils.OafToIndexRecordFactory;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;

public class FeedMissingClaimsJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(FeedMissingClaimsJobNode.class);
    private RecentResultsQueue queue;
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Value(value="${openaireplus.msro.api.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;
    @Autowired
    private SolrIndexClientFactory indexClientFactory;

    protected String execute(NodeToken nodeToken) throws Exception {
        String format = nodeToken.getEnv().hasAttribute("format") ? nodeToken.getEnv().getAttribute("format") : nodeToken.getFullEnv().getAttribute("format");
        String coll = format + "-index-openaire";
        String indexDsId = nodeToken.getEnv().getAttribute("index_id");
        try (SolrIndexClient indexClient = (SolrIndexClient)this.indexClientFactory.getClient(coll);){
            ArrayList<SolrInputDocument> toFeed = new ArrayList<SolrInputDocument>();
            ArrayList<String> toDeleteFromCache = new ArrayList<String>();
            SAXReader reader = new SAXReader();
            ApplyXslt xslt = this.oafToIndexRecordFactory.newTransformer(format);
            for (String record : this.queue) {
                String id = reader.read((Reader)new StringReader(record)).valueOf("//*[local-name() = 'objIdentifier']");
                if (indexClient.isRecordIndexed(id)) {
                    toDeleteFromCache.add(id);
                    continue;
                }
                toFeed.add(indexClient.prepareSolrDocument(record, indexDsId, (UnaryFunction)xslt));
            }
            indexClient.feed(toFeed, null);
            this.queue.remove(toDeleteFromCache);
        }
        catch (Throwable e) {
            log.error((Object)"Error feeding missing claims", e);
            throw new MSROException("Error feeding missing claims: " + e.getMessage(), e);
        }
        return Arc.DEFAULT_ARC;
    }

    public RecentResultsQueue getQueue() {
        return this.queue;
    }

    @Required
    public void setQueue(RecentResultsQueue queue) {
        this.queue = queue;
    }

    public OafToIndexRecordFactory getOafToIndexRecordFactory() {
        return this.oafToIndexRecordFactory;
    }

    @Required
    public void setOafToIndexRecordFactory(OafToIndexRecordFactory oafToIndexRecordFactory) {
        this.oafToIndexRecordFactory = oafToIndexRecordFactory;
    }

    private String calculateIndexBaseUrl() throws Exception {
        String query = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
    }
}

