SELECT
	po.project                                                              AS project,
	po.resporganization                                                     AS resporganization,
	po.participantnumber                                                    AS participantnumber,
	po.startdate                                                            AS startdate,
	po.enddate                                                              AS enddate,
	po.inferred                                                             AS inferred,
	po.deletedbyinference                                                   AS deletedbyinference,
	po.trust                                                                AS trust,
	po.inferenceprovenance                                                  AS inferenceprovenance,

	poc.code || '@@@' || poc.name || '@@@' || pos.code || '@@@' || pos.name AS semantics,
	pac.code || '@@@' || pac.name || '@@@' || pas.code || '@@@' || pas.name AS provenanceaction

FROM project_organization po

	LEFT OUTER JOIN projects p ON (po.project = p.id)

	LEFT OUTER JOIN class pac ON (pac.code = p.provenanceactionclass)
	LEFT OUTER JOIN scheme pas ON (pas.code = p.provenanceactionscheme)

	LEFT OUTER JOIN class poc ON (poc.code = po.semanticclass)
	LEFT OUTER JOIN scheme pos ON (pos.code = po.semanticscheme)
