package eu.dnetlib.msro.openaire.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.data.download.rmi.DownloadService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadPluginValues extends ValidNodeValuesFetcher {

	/**
	 * The download plugin enumerator.
	 */

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Autowired(required = false)
	private List<DownloadPlugin> plugins;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {

		List<String> otherPlugins = serviceLocator.getService(DownloadService.class).listPlugins();

		ArrayList<DnetParamValue> output = new ArrayList<ValidNodeValuesFetcher.DnetParamValue>();

		// if (plugins != null) {
		// output.addAll(Lists.newArrayList(Iterables.transform(plugins, new Function<DownloadPlugin, DnetParamValue>() {
		//
		// @Override
		// public DnetParamValue apply(final DownloadPlugin input) {
		// return new DnetParamValue(input.getPluginName(), input.getPluginName());
		// }
		// })));
		// }

		if (otherPlugins != null) {
			for (String pluginName : otherPlugins) {
				output.add(new DnetParamValue(pluginName, pluginName));
			}
		}

		return output;
	}
}
