/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.openaireplus.workflows.nodes.stats.AbstractStatsJobNode;
import eu.dnetlib.msro.openaireplus.workflows.nodes.stats.StatsManagerServiceBBAction;
import eu.dnetlib.msro.rmi.MSROException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MigrateStatsCacheJobNode
extends AbstractStatsJobNode {
    private static final Log log = LogFactory.getLog(MigrateStatsCacheJobNode.class);
    private String sourcePortal;

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        job.setAction(StatsManagerServiceBBAction.MIGRATE_CACHE.action());
        if (StringUtils.isBlank((String)this.sourcePortal)) {
            throw new MSROException("Parameter sourcePortal required to migrate the cache");
        }
        job.getParameters().put(StatsManagerServiceBBAction.MIGRATE_CACHE.getSourcePortalParamName(), this.sourcePortal);
        String targetPortal = this.getPortalName(token);
        if (StringUtils.isNotBlank((String)targetPortal)) {
            job.getParameters().put(StatsManagerServiceBBAction.MIGRATE_CACHE.getTargetPortalParamName(), targetPortal);
        } else {
            log.warn((Object)(StatsManagerServiceBBAction.MIGRATE_CACHE.getTargetPortalParamName() + " not set. The StatsManagerService will use its default."));
        }
    }

    public String getSourcePortal() {
        return this.sourcePortal;
    }

    public void setSourcePortal(String sourcePortal) {
        this.sourcePortal = sourcePortal;
    }
}

