package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessContextsJobNode extends SimpleJobNode implements ProgressJobNode {

	private static final Log log = LogFactory.getLog(ProcessContextsJobNode.class);

	private String eprParam;
	private String contextObj;
	private ResultsetProgressProvider progressProvider;
	private String contextId;
	private String contextLabel;
	private String contextType;

	private String contextParams;

	@Resource
	private ResultSetClientFactory resultSetClientFactory;

	@Resource
	private ProcessCountingResultSetFactory processCountingResultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String epr = token.getEnv().getAttribute(eprParam);

		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);

		final Iterable<String> iter = resultSetClientFactory.getClient(progressProvider.getEpr());

		final ContextDesc context = ContextUtils.getContext(iter, getContextId(), getContextLabel(), getContextType(), getContextParams());

		token.getEnv().setTransientAttribute(contextObj, context);

		return Arc.DEFAULT_ARC;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public String getContextObj() {
		return contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return progressProvider;
	}

	public String getContextId() {
		return contextId;
	}

	public void setContextId(final String contextId) {
		this.contextId = contextId;
	}

	public String getContextLabel() {
		return contextLabel;
	}

	public void setContextLabel(final String contextLabel) {
		this.contextLabel = contextLabel;
	}

	public String getContextType() {
		return contextType;
	}

	public void setContextType(final String contextType) {
		this.contextType = contextType;
	}

	public String getContextParams() {
		return contextParams;
	}

	public void setContextParams(final String contextParams) {
		this.contextParams = contextParams;
	}
}
