<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>
		<ARC to="obtainParams" />
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("orig_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("orig_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="generateRows"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="generateRows"/>
	</ARCS>
</NODE>

<NODE name="generateRows" type="ApplyXslt" isJoin="true">
	<DESCRIPTION>Transform original records in DB rows</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="system">/eu/dnetlib/msro/openaireplus/workflows/repo-hi/xslt-datacite/datacite_sets_2_db.xslt</PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">orig_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">packed_row_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="storeRowRecords"/>
	</ARCS>
</NODE>

<NODE name="storeRowRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("row_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">packed_row_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

 <NODE name="UPDATE_INFO" type="MDStoreToApiExtraField">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("row_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_aggregation_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_aggregation_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
