<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" version="1.0"
                exclude-result-prefixes="fn">

	<xsl:output indent="yes"/>

	<xsl:template match="/">
		<fundings>
			<fundingtree>
				<funder>
					<id>mestd_______::MESTD</id>
					<shortname>MESTD</shortname>
					<name>Ministry of Education, Science and Technological Development of Republic of Serbia</name>
					<originalname>Ministarstvo Prosvete, Nauke i Tehnološkog Razvoja</originalname>
					<jurisdiction>RS</jurisdiction>
				</funder>
			</fundingtree>
			<fundingtree>
				<funder>
					<id>mestd_______::MESTD</id>
					<shortname>MESTD</shortname>
					<name>Ministry of Education, Science and Technological Development of Republic of Serbia</name>
					<originalname>Ministarstvo Prosvete, Nauke i Tehnološkog Razvoja</originalname>
					<jurisdiction>RS</jurisdiction>
				</funder>
				<funding_level_0>
					<id>
						<xsl:value-of select="concat('mestd_______::MESTD::', normalize-space(//column[./@name='FUNDING STREAM(S)']))"/>
					</id>
					<name>
						<xsl:value-of select="normalize-space(//column[./@name='FUNDING STREAM(S)'])"/>
					</name>
					<description>
						<xsl:value-of select="normalize-space(//column[./@name='FUNDING STREAM(S)'])"/>
					</description>
					<parent></parent>
					<class>mestd:fundingStream</class>
				</funding_level_0>
			</fundingtree>

		</fundings>
	</xsl:template>
</xsl:stylesheet>

