<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>
	<xsl:param name="quote">"</xsl:param>

	<xsl:variable name="funderID" select="concat($namespacePrefix, '::NIH')"/>
	<xsl:variable name="fundingName" select="upper-case(normalize-space(//IC_NAME))"/>
	<xsl:variable name="fundingID">
		<xsl:choose>
			<xsl:when test="$fundingName != ''">
				<xsl:value-of select="concat($funderID, '::', $fundingName)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$funderID"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="projectID" select="concat($namespacePrefix, '::', .//FULL_PROJECT_NUM)"/>
	<xsl:variable name="orgID" select="concat($namespacePrefix, '::', upper-case(translate(.//ORG_NAME, ' ,', '__')))"/>

	<xsl:variable name="terms" select="string-join(.//PROJECT_TERMS/TERM/text(), ',')"/>
	<xsl:variable name="termsx" select="string-join(.//PROJECT_TERMSX/TERM/text(), ',')"/>

	<xsl:template name="getJson">
		<xsl:param name="varName"/>
		<xsl:param name="value"/>
		<xsl:value-of select="concat($quote, $varName, $quote, ':', $quote, $value, $quote)"/>
	</xsl:template>

	<xsl:template match="/">
		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<xsl:if test="string-length(normalize-space(.//PROJECT_TITLE)) &gt; 0 and string-length($projectID) &gt; 0">

						<xsl:variable name="startDate" select=".//PROJECT_START"/>
						<xsl:variable name="endDate" select=".//PROJECT_END"/>

						<xsl:variable name="orgname">
							<xsl:call-template name="getJson">
								<xsl:with-param name="varName">orgname</xsl:with-param>
								<xsl:with-param name="value">
									<xsl:value-of select=".//ORG_NAME"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="activity">
							<xsl:call-template name="getJson">
								<xsl:with-param name="varName">activity</xsl:with-param>
								<xsl:with-param name="value">
									<xsl:value-of select=".//ACTIVITY"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="administeringic">
							<xsl:call-template name="getJson">
								<xsl:with-param name="varName">administeringic</xsl:with-param>
								<xsl:with-param name="value">
									<xsl:value-of select=".//ADMINISTERING_IC"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="serialnumber">
							<xsl:call-template name="getJson">
								<xsl:with-param name="varName">serialnumber</xsl:with-param>
								<xsl:with-param name="value">
									<xsl:value-of select=".//SERIAL_NUMBER"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="coreprojectnum">
							<xsl:call-template name="getJson">
								<xsl:with-param name="varName">coreprojectnum</xsl:with-param>
								<xsl:with-param name="value">
									<xsl:value-of select=".//CORE_PROJECT_NUM"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>

						<xsl:variable name="jsonExtra">
							<xsl:value-of select="concat('{', $orgname, ',', $activity, ',', $administeringic ,',',$serialnumber, ',', $coreprojectnum, '}')"/>
						</xsl:variable>

						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="code">
								<xsl:value-of select=".//FULL_PROJECT_NUM"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="MM/dd/yyyy">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="MM/dd/yyyy">
								<xsl:value-of select="$endDate"/>
							</FIELD>
							<FIELD name="title">
								<xsl:value-of select=".//PROJECT_TITLE"/>
							</FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>
							<FIELD name="optional1">
								<xsl:value-of select="concat(.//TOTAL_COST, ' $')"/>
							</FIELD>
							<FIELD name="jsonextrainfo">
								<xsl:value-of select="$jsonExtra"/>
							</FIELD>
						</ROW>
						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($fundingID,'@@', $projectID)"/>
							</FIELD>
							<FIELD name="funding">
								<xsl:value-of select="$fundingID"/>
							</FIELD>
							<FIELD name="project">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="MM/dd/yyyy">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="MM/dd/yyyy">
								<xsl:value-of select="$endDate"/>
							</FIELD>
						</ROW>
						<xsl:if test="string-length($orgID) &gt; 4">
							<ROW table="organizations">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="$orgID"/>
								</FIELD>
								<FIELD name="id">
									<xsl:value-of select="$orgID"/>
								</FIELD>
								<FIELD name="legalname">
									<xsl:value-of select=".//ORG_NAME"/>
								</FIELD>
								<FIELD name="collectedfrom">
									<xsl:value-of select="$parentDatasourceId"/>
								</FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
								<FIELD name="trust" type="float">0.8</FIELD>
							</ROW>
							<ROW table="project_organization">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="concat($projectID, '@@', $orgID)"/>
								</FIELD>
								<FIELD name="participantnumber" type="int">1</FIELD>
								<FIELD name="startdate" type="date" format="MM/dd/yyyy">
									<xsl:value-of select="$startDate"/>
								</FIELD>
								<FIELD name="enddate" type="date" format="MM/dd/yyyy">
									<xsl:value-of select="$endDate"/>
								</FIELD>
								<FIELD name="project">
									<xsl:value-of select="$projectID"/>
								</FIELD>
								<FIELD name="resporganization">
									<xsl:value-of select="$orgID"/>
								</FIELD>
								<FIELD name="semanticclass">participant</FIELD>
								<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
							</ROW>
						</xsl:if>
					</xsl:if>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
