/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class OpenaireMdBuilderJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(OpenaireMdBuilderJobNode.class);
    private StringTemplate mdBuilderTemplateXslt;
    private String inputEprParam;
    private String outputEprParam;
    private String datasourceId;
    private String datasourceInterface;
    private boolean inferred = false;
    private boolean deletedbyinference = false;
    private String inferenceprovenance = "";
    private String trust = "";
    private String provenanceactionclassname = "";
    private String provenanceactionclassid = "";
    private String overridingMetadataIdentifierXPath = "";
    private XSLTMappedResultSetFactory xsltMappedResultSetFactory;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected String execute(NodeToken token) throws MSROException {
        String inputEpr = token.getEnv().getAttribute(this.inputEprParam);
        if (inputEpr == null || inputEpr.isEmpty()) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        try {
            StringTemplate st = new StringTemplate(this.getMdBuilderTemplateXslt().getTemplate());
            st.setAttribute("xpath", (Object)this.getMetadataIdentifierXPath());
            st.setAttribute("datasourceId", (Object)this.datasourceId);
            if (token.getEnv().hasAttribute("namespacePrefix")) {
                st.setAttribute("namespacePrefix", (Object)token.getEnv().getAttribute("namespacePrefix"));
            } else {
                st.setAttribute("namespacePrefix", (Object)this.datasourceId);
            }
            st.setAttribute("inferred", (Object)String.valueOf(this.getInferred()));
            st.setAttribute("deletedbyinference", (Object)String.valueOf(this.getDeletedbyinference()));
            st.setAttribute("inferenceprovenance", (Object)this.getInferenceprovenance());
            st.setAttribute("trust", (Object)this.getTrust());
            st.setAttribute("provenanceactionclassname", (Object)this.getProvenanceactionclassname());
            st.setAttribute("provenanceactionclassid", (Object)this.getProvenanceactionclassid());
            st.setAttribute("baseurl", (Object)this.getBaseUrl());
            st.setAttribute("metadatanamespace", (Object)this.getMetadataNamespace());
            W3CEndpointReference epr = this.xsltMappedResultSetFactory.createMappedResultSet(new EPRUtils().getEpr(inputEpr), st.toString());
            token.getEnv().setAttribute(this.outputEprParam, epr.toString());
            return Arc.DEFAULT_ARC;
        }
        catch (ISLookUpException e) {
            throw new MSROException("Error while initializing mdBuilder template for datasource " + this.datasourceId, (Throwable)e);
        }
    }

    private String getMetadataIdentifierXPath() throws ISLookUpException {
        String xQuery = String.format("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return $x//INTERFACE[@id='%s']/INTERFACE_EXTRA_FIELD[@name='metadata_identifier_path']/string()", this.getDatasourceInterface());
        return this.hasOverridingMetadataIdentifierXPath() ? this.getOverridingMetadataIdentifierXPath() : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xQuery);
    }

    private String getBaseUrl() throws ISLookUpException {
        String xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']//BASE_URL/string()";
        xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface).replace("{datasourceId}", this.datasourceId);
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xQuery);
    }

    private String getMetadataNamespace() {
        try {
            String xQuery = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']/ACCESS_PROTOCOL/@format/string() return /*[.//RESOURCE_TYPE/@value='MetadataFormatDSResourceType']//METADATAFORMAT[@Prefix=$x]/@NameSpace/string()";
            xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface).replace("{datasourceId}", this.datasourceId);
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xQuery);
        }
        catch (ISLookUpException e) {
            log.error((Object)"The interface is not OAI or the format is not found in the MetadataFormatDSResourceType, thus metadata format in the <about> section cannot managed here and it will be leaved empty (for the time being)");
            return "";
        }
    }

    private boolean hasOverridingMetadataIdentifierXPath() {
        return !this.getOverridingMetadataIdentifierXPath().isEmpty();
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
        return this.xsltMappedResultSetFactory;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    @Required
    public void setXsltMappedResultSetFactory(XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
        this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
    }

    public StringTemplate getMdBuilderTemplateXslt() {
        return this.mdBuilderTemplateXslt;
    }

    public void setMdBuilderTemplateXslt(StringTemplate mdBuilderTemplateXslt) {
        this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
    }

    public boolean getInferred() {
        return this.inferred;
    }

    public void setInferred(boolean inferred) {
        this.inferred = inferred;
    }

    public boolean getDeletedbyinference() {
        return this.deletedbyinference;
    }

    public void setDeletedbyinference(boolean deletedbyinference) {
        this.deletedbyinference = deletedbyinference;
    }

    public String getInferenceprovenance() {
        return this.inferenceprovenance;
    }

    public void setInferenceprovenance(String inferenceprovenance) {
        this.inferenceprovenance = inferenceprovenance;
    }

    public String getTrust() {
        return this.trust;
    }

    public void setTrust(String trust) {
        this.trust = trust;
    }

    public String getProvenanceactionclassname() {
        return this.provenanceactionclassname;
    }

    public void setProvenanceactionclassname(String provenanceactionclassname) {
        this.provenanceactionclassname = provenanceactionclassname;
    }

    public String getProvenanceactionclassid() {
        return this.provenanceactionclassid;
    }

    public void setProvenanceactionclassid(String provenanceactionclassid) {
        this.provenanceactionclassid = provenanceactionclassid;
    }

    public String getOverridingMetadataIdentifierXPath() {
        return this.overridingMetadataIdentifierXPath;
    }

    public void setOverridingMetadataIdentifierXPath(String overridingMetadataIdentifierXPath) {
        this.overridingMetadataIdentifierXPath = overridingMetadataIdentifierXPath;
    }
}

