<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dnet="eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions"
                version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:variable name="dsId" select="concat($namespacePrefix, '::', normalize-space(.//*[local-name()='re3data.orgIdentifier']))"/>
	<xsl:variable name="subjects">
		<xsl:for-each select="//*[local-name()='subject']">
			<xsl:if test="position() &gt; 1">,</xsl:if>
			<xsl:value-of select="concat('&quot;', substring-after(., ' '), '&quot;')"/>
		</xsl:for-each>
	</xsl:variable>

	<xsl:template match="/">
		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<ROW table="dsm_datasources">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$dsId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$dsId"/>
						</FIELD>
						<FIELD name="officialName">
							<xsl:value-of select=".//*[local-name()='repositoryName']"/>
						</FIELD>
						<FIELD name="englishName">
							<xsl:value-of select=".//*[local-name()='additionalName'][@language='eng']"/>
						</FIELD>
						<FIELD name="websiteurl">
							<xsl:value-of select=".//*[local-name()='repositoryURL']"/>
						</FIELD>
						<FIELD name="namespaceprefix">
							<xsl:value-of select="dnet:generateNsPrefix('r3', dnet:md5(normalize-space(.//*[local-name()='re3data.orgIdentifier'])))"/>
						</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="typology">datarepository::unknown</FIELD>
						<FIELD name="provenanceaction">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="platform">
							<xsl:value-of select=".//*[local-name()='software']/*[local-name()='softwareName']"/>
						</FIELD>
						<FIELD name="description">
							<xsl:value-of select="./*[local-name()='description']"/>
						</FIELD>
						<FIELD name="releasestartdate" type="date">
							<xsl:value-of select=".//*[local-name()='startDate']"/>
						</FIELD>
						<FIELD name="releaseenddate" type="date">
							<xsl:value-of select=".//*[local-name()='endDate']"/>
						</FIELD>
						<FIELD name="missionstatementurl">
							<xsl:value-of select=".//*[local-name()='missionStatementURL']"/>
						</FIELD>

						<xsl:choose>
							<xsl:when test=".//*[local-name()='providerType'] = 'dataProvider'">
								<FIELD name="dataprovider" type="boolean">true</FIELD>
							</xsl:when>
							<xsl:otherwise>
								<FIELD name="dataprovider" type="boolean">false</FIELD>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test=".//*[local-name()='providerType'] = 'serviceProvider'">
								<FIELD name="serviceprovider" type="boolean">true</FIELD>
							</xsl:when>
							<xsl:otherwise>
								<FIELD name="serviceprovider" type="boolean">false</FIELD>
							</xsl:otherwise>
						</xsl:choose>
						<FIELD name="databaseaccesstype">
							<xsl:value-of select=".//*[local-name()='databaseAccessType']"/>
						</FIELD>
						<FIELD name="datauploadtype">
							<xsl:value-of select=".//*[local-name()='dataUploadType']"/>
						</FIELD>
						<FIELD name="databaseaccessrestriction">
							<xsl:value-of select=".//*[local-name()='databaseAccessRestriction']"/>
						</FIELD>
						<FIELD name="datauploadrestriction">
							<xsl:value-of select=".//*[local-name()='dataUploadRestriction']"/>
						</FIELD>
						<xsl:choose>
							<xsl:when test=".//*[local-name()='versioning'] = 'yes'">
								<FIELD name="versioning" type="boolean">true</FIELD>
							</xsl:when>
							<xsl:otherwise>
								<FIELD name="versioning" type="boolean">false</FIELD>
							</xsl:otherwise>
						</xsl:choose>
						<FIELD name="citationguidelineurl">
							<xsl:value-of select=".//*[local-name()='citationGuidelineURL']"/>
						</FIELD>
						<FIELD name="qualitymanagementkind">
							<xsl:value-of select=".//*[local-name()='qualityManagement']"/>
						</FIELD>
						<FIELD name="pidsystems">
							<xsl:value-of select=".//*[local-name()='pidSystem']"/>
						</FIELD>
						<FIELD name="certificates">
							<xsl:value-of select=".//*[local-name()='certificate']"/>
						</FIELD>
						<FIELD name="subjects">
							<xsl:value-of select="concat('{', normalize-space($subjects), '}')"/>
						</FIELD>
					</ROW>

					<xsl:for-each select="//*[local-name()='api']">
						<xsl:variable name="apiId" select="concat('api_________::', $dsId, '::', position())"/>
						<xsl:variable name="baseURL" select="normalize-space(.)"/>
						<ROW table="dsm_api">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$apiId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$apiId"/>
							</FIELD>
							<FIELD name="protocol">
								<xsl:value-of select="normalize-space(@apiType)"/>
							</FIELD>
							<FIELD name="datasource">
								<xsl:value-of select="$dsId"/>
							</FIELD>
							<FIELD name="contentdescription">metadata</FIELD>
							<FIELD name="typology">datarepository::unknown</FIELD>

							<FIELD name="baseurl">
								<xsl:value-of select="$baseURL"/>
							</FIELD>
						</ROW>

						<!-- CANNOT ASSUME THE FORMAT IS oai_dc
						<ROW table="dsm_apiparams">
							<FIELD name="api">
								<xsl:value-of select="$apiId"/>
							</FIELD>
							<FIELD name="param">format</FIELD>
							<FIELD name="value">oai_dc</FIELD>
						</ROW>
						-->
					</xsl:for-each>

					<xsl:for-each select="//*[local-name()='institution']">
						<xsl:variable name="orgId" select="concat($namespacePrefix, '::', dnet:md5(normalize-space(./*[local-name()='institutionName'])))"/>
						<ROW table="dsm_organizations">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$orgId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$orgId"/>
							</FIELD>
							<FIELD name="legalname">
								<xsl:value-of select="./*[local-name()='institutionName']"/>
							</FIELD>
							<FIELD name="legalshortname">
								<xsl:value-of select="./*[local-name()='institutionAdditionalName'][1]"/>
							</FIELD>
							<FIELD name="websiteurl">
								<xsl:choose>
									<xsl:when test="starts-with(normalize-space(./*[local-name()='institutionURL']), 'http')">
										<xsl:value-of select="./*[local-name()='institutionURL']"/>
									</xsl:when>
									<xsl:when test="string-length(normalize-space(./*[local-name()='institutionURL'])) &gt; 0">
										<xsl:value-of select="concat('http://', normalize-space(./*[local-name()='institutionURL']))"/>
									</xsl:when>
								</xsl:choose>
							</FIELD>
							<FIELD name="country">
								<xsl:value-of select="./*[local-name()='institutionCountry']"/>
							</FIELD>
							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>
							<FIELD name="provenanceaction">sysimport:crosswalk:entityregistry</FIELD>
						</ROW>

						<ROW table="dsm_datasource_organization">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($dsId, '@@', $orgId)"/>
							</FIELD>
							<FIELD name="datasource">
								<xsl:value-of select="$dsId"/>
							</FIELD>
							<FIELD name="organization">
								<xsl:value-of select="$orgId"/>
							</FIELD>
						</ROW>
					</xsl:for-each>

				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>

