/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.profiles;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class RepositoryXsltFunctions {
    private static final Log log = LogFactory.getLog(RepositoryXsltFunctions.class);
    private static Resource ifaceTemplate = new ClassPathResource("/eu/dnetlib/msro/openaireplus/workflows/profiles/repo_interface.st");
    private static Resource paramTemplate = new ClassPathResource("/eu/dnetlib/msro/openaireplus/workflows/profiles/repo_param.st");

    public static String buildInterface(String infopackage) {
        ArrayList formats = Lists.newArrayList();
        ArrayList sets = Lists.newArrayList();
        HashMap otherParams = Maps.newHashMap();
        for (String param : RepositoryXsltFunctions.parseParams(RepositoryXsltFunctions.getValueBetween(infopackage, "===6===", null))) {
            StringTemplate p = RepositoryXsltFunctions.getTemplate(paramTemplate);
            String paramName = StringUtils.substringBefore((String)param, (String)"=").trim();
            String paramValue = StringUtils.substringAfter((String)param, (String)"=").trim();
            p.setAttribute("param", (Object)paramName.toUpperCase());
            p.setAttribute("value", (Object)paramValue);
            try {
                switch (Params.valueOf(paramName.toUpperCase())) {
                    case FORMAT: {
                        formats.add(p.toString());
                        break;
                    }
                    case SET: {
                        sets.add(p.toString());
                    }
                }
            }
            catch (Exception e) {
                if (paramName == null || paramName.isEmpty()) continue;
                otherParams.put(paramName, StringEscapeUtils.escapeXml((String)paramValue));
            }
        }
        StringTemplate i = RepositoryXsltFunctions.getTemplate(ifaceTemplate);
        i.setAttribute("id", (Object)RepositoryXsltFunctions.getValueBetween(infopackage, null, "===1==="));
        i.setAttribute("fileMode", (Object)RepositoryXsltFunctions.getValueBetween(infopackage, "===1===", "===2==="));
        i.setAttribute("fileDesc", (Object)RepositoryXsltFunctions.getValueBetween(infopackage, "===2===", "===3==="));
        i.setAttribute("iisWf", (Object)RepositoryXsltFunctions.getValueBetween(infopackage, "===3===", "===4==="));
        i.setAttribute("baseUrl", (Object)RepositoryXsltFunctions.getBaseUrl(RepositoryXsltFunctions.getValueBetween(infopackage, "===4===", "===5===")));
        i.setAttribute("accessProtocol", (Object)RepositoryXsltFunctions.getAccessProtocol(RepositoryXsltFunctions.getValueBetween(infopackage, "===5===", "===6==="), otherParams));
        i.setAttribute("formats", RepositoryXsltFunctions.ensureMinOccurs(formats, "<FORMAT/>"));
        i.setAttribute("sets", RepositoryXsltFunctions.ensureMinOccurs(sets, "<SET/>"));
        if (!otherParams.isEmpty()) {
            i.setAttribute("otherParams", (Object)otherParams);
        }
        String iface = i.toString();
        return iface;
    }

    private static String getValueBetween(String s, String pre, String post) {
        if (pre == null && post == null) {
            return s;
        }
        if (pre == null) {
            return StringUtils.substringBefore((String)s, (String)post);
        }
        if (post == null) {
            return StringUtils.substringAfter((String)s, (String)pre);
        }
        return StringUtils.substringBetween((String)s, (String)pre, (String)post);
    }

    private static List<String> ensureMinOccurs(List<String> list, String empty) {
        if (list.isEmpty()) {
            list.add(empty);
        }
        return list;
    }

    private static Iterable<String> parseParams(String s) {
        return Splitter.on((String)"***").omitEmptyStrings().trimResults().split((CharSequence)s);
    }

    private static String getBaseUrl(String url) {
        StringTemplate b = RepositoryXsltFunctions.getTemplate(paramTemplate);
        b.setAttribute("param", (Object)"BASE_URL");
        b.setAttribute("value", (Object)url);
        return b.toString();
    }

    private static String getAccessProtocol(String protocol, Map<String, String> otherParams) {
        StringTemplate a = RepositoryXsltFunctions.getTemplate(paramTemplate);
        a.setAttribute("param", (Object)"ACCESS_PROTOCOL");
        a.setAttribute("value", (Object)protocol);
        if (otherParams != null && !otherParams.isEmpty()) {
            a.setAttribute("attrs", otherParams);
        }
        return a.toString();
    }

    private static StringTemplate getTemplate(Resource res) {
        StringWriter body = new StringWriter();
        try {
            IOUtils.copy((InputStream)res.getInputStream(), (Writer)body);
            return new StringTemplate(body.toString());
        }
        catch (IOException e) {
            log.error((Object)"unable to get template", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static enum Params {
        FORMAT,
        SET;

    }
}

