/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.api;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.common.rmi.DNetRestDocumentation;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.index.client.IndexClientFactory;
import eu.dnetlib.functionality.index.client.solr.SolrIndexClient;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.openaireplus.api.RecentResultsQueue;
import eu.dnetlib.msro.openaireplus.api.objects.ResultEntry;
import eu.dnetlib.msro.openaireplus.utils.OafToIndexRecordFactory;
import eu.dnetlib.msro.rmi.MSROException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@DNetRestDocumentation
public class OpenaireResultSubmitter {
    private static final Log log = LogFactory.getLog(OpenaireResultSubmitter.class);
    @Value(value="oaf.schema.location")
    private String oafSchemaLocation;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private RecentResultsQueue recentResultsQueue;
    @Resource(name="openaireplusApisVelocityEngine")
    private VelocityEngine velocityEngine;
    @Value(value="${openaireplus.msro.api.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;
    @Value(value="${openaireplus.msro.api.findIndexDsInfo.xquery}")
    private ClassPathResource findIndexDsInfo;
    @Autowired
    private IndexClientFactory indexClientFactory;

    @Deprecated
    @RequestMapping(value={"/api/publications/feedJson", "/api/results/feedJson"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedObjectJson(@RequestParam(value="json", required=true) String json, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws MSROException {
        ResultEntry pub = (ResultEntry)new Gson().fromJson(json, ResultEntry.class);
        return this.feedObject(pub, commit);
    }

    @RequestMapping(value={"/api/results/feedObject"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedResult(@RequestBody ResultEntry pub, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws MSROException {
        try {
            return this.feedObject(pub, commit);
        }
        catch (Throwable e) {
            throw new MSROException("Error adding publication: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/api/publications/feedObject"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedObject(@RequestBody ResultEntry pub, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws MSROException {
        try {
            List<IndexDsInfo> idxList = this.calculateCurrentIndexDsInfo();
            if (idxList == null || idxList.isEmpty()) {
                throw new MSROException("Cannot add result: " + pub.getAnyId() + " : No public Search Service found");
            }
            if (idxList.size() > 1) {
                log.warn((Object)"Found more than 1 public search service");
            }
            String oafRecord = pub.asOafRecord(this.velocityEngine, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class), this.oafSchemaLocation);
            for (IndexDsInfo idx : idxList) {
                try {
                    SolrIndexClient idxClient = (SolrIndexClient)this.indexClientFactory.getClient(idx.getColl());
                    Throwable throwable = null;
                    try {
                        idxClient.feed(oafRecord, idx.getIndexDsId(), (UnaryFunction)this.oafToIndexRecordFactory.newTransformer(idx.getFormat()), commit);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (idxClient == null) continue;
                        if (throwable != null) {
                            try {
                                idxClient.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        idxClient.close();
                    }
                }
                catch (Throwable e) {
                    throw new MSROException("Error adding publication: " + e.getMessage(), e);
                }
            }
            this.recentResultsQueue.add(oafRecord);
            return pub.getOpenaireId();
        }
        catch (Throwable e) {
            log.debug((Object)pub.toString());
            throw new MSROException("Error adding publication: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/api/result/{openaireId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean deleteResultWithOpenaireId(@PathVariable(value="openaireId") String openaireId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws MSROException {
        return this.deleteResult(openaireId, commit);
    }

    @RequestMapping(value={"/api/results"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean deleteResultWithOriginalId(@RequestParam(value="originalId", required=true) String originalId, @RequestParam(value="collectedFromId", required=true) String collectedFromId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws Exception {
        String openaireId = ResultEntry.calculateOpenaireId(originalId, collectedFromId, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class));
        return this.deleteResult(openaireId, commit);
    }

    @Deprecated
    @RequestMapping(value={"/api/publications/deleteObject", "/api/results/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean deleteResultPost(@RequestParam(value="originalId", required=true) String originalId, @RequestParam(value="collectedFromId", required=true) String collectedFromId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws Exception {
        String openaireId = ResultEntry.calculateOpenaireId(originalId, collectedFromId, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class));
        return this.deleteResult(openaireId, commit);
    }

    private boolean deleteResult(String openaireId, boolean commit) throws MSROException {
        try {
            List<IndexDsInfo> idxList = this.calculateCurrentIndexDsInfo();
            if (idxList == null || idxList.isEmpty()) {
                throw new MSROException("Cannot delete result: " + openaireId + " : No public Search Service found");
            }
            if (idxList.size() > 1) {
                log.warn((Object)"Found more than 1 public search service");
            }
            for (IndexDsInfo idx : idxList) {
                try {
                    SolrIndexClient idxClient = (SolrIndexClient)this.indexClientFactory.getClient(idx.getColl());
                    Throwable throwable = null;
                    try {
                        idxClient.remove(openaireId, commit);
                        log.info((Object)("Deleted result with id: " + openaireId + " from: " + idx.getIndexBaseUrl()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (idxClient == null) continue;
                        if (throwable != null) {
                            try {
                                idxClient.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        idxClient.close();
                    }
                }
                catch (Throwable e) {
                    throw new MSROException("Error deleting publication: " + e.getMessage(), e);
                }
            }
            this.recentResultsQueue.remove(openaireId);
            return true;
        }
        catch (ISLookUpException | IOException e) {
            throw new MSROException("Error deleting publication: " + e.getMessage(), e);
        }
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(Exception e) {
        log.error((Object)"Error in direct index API", (Throwable)e);
        return new ErrorMessage(e);
    }

    private List<IndexDsInfo> calculateCurrentIndexDsInfo() throws IOException, ISLookUpException {
        ArrayList list = Lists.newArrayList();
        String queryUrl = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        String queryDs = IOUtils.toString((InputStream)this.findIndexDsInfo.getInputStream());
        ISLookUpService lu = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String indexBaseUrl = lu.getResourceProfileByQuery(queryUrl);
        List idxDs = lu.quickSearchProfile(queryDs);
        for (String idx : idxDs) {
            String[] arr = idx.split("@@@");
            list.add(new IndexDsInfo(indexBaseUrl, arr[0].trim(), arr[1].trim(), arr[2].trim()));
        }
        return list;
    }

    public class ErrorMessage {
        private final String message;
        private final String stacktrace;

        public ErrorMessage(Exception e) {
            this(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
        }

        public ErrorMessage(String message, String stacktrace) {
            this.message = message;
            this.stacktrace = stacktrace;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStacktrace() {
            return this.stacktrace;
        }
    }

    public class IndexDsInfo {
        private final String indexBaseUrl;
        private final String indexDsId;
        private final String format;
        private final String coll;

        public IndexDsInfo(String indexBaseUrl, String indexDsId, String format, String coll) {
            this.indexBaseUrl = indexBaseUrl;
            this.indexDsId = indexDsId;
            this.format = format;
            this.coll = coll;
        }

        public String getIndexBaseUrl() {
            return this.indexBaseUrl;
        }

        public String getIndexDsId() {
            return this.indexDsId;
        }

        public String getFormat() {
            return this.format;
        }

        public String getColl() {
            return this.coll;
        }
    }
}

