/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IncrementalTransformationJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(IncrementalTransformationJobNode.class);
    private String transformationType;
    @Autowired
    private DnetLogger dnetLogger;
    @Autowired
    private UniqueServiceLocator locator;
    private static final DateUtils dateUtils = new DateUtils();

    protected String execute(NodeToken nodeToken) throws Exception {
        if ("incremental".equalsIgnoreCase(this.transformationType)) {
            String currentWfProfileId = this.findCurrentWfProfileId(nodeToken);
            Long lastSuccessEndDate = this.findLastSuccessEndDate(currentWfProfileId);
            if (lastSuccessEndDate < 0L) {
                log.info((Object)"Last success date <0 the transformation will be forced to REFRESH");
                nodeToken.getFullEnv().setAttribute("transformationType", "REFRESH");
                return Arc.DEFAULT_ARC;
            }
            log.info((Object)("Last succes date " + lastSuccessEndDate));
            long lastUpdateDate = this.getLastTransformationRuleUpdate(this.getTransformationId(currentWfProfileId));
            log.info((Object)("last update date of the trId is " + lastUpdateDate));
            if (lastUpdateDate > lastSuccessEndDate) {
                log.info((Object)"Transformation Rule has benn updated, hence the transformation process will be forced to REFRESH");
                nodeToken.getFullEnv().setAttribute("transformationType", "REFRESH");
                return Arc.DEFAULT_ARC;
            }
            nodeToken.getFullEnv().setAttribute("transformationType", "INCREMENTAL");
            nodeToken.getFullEnv().setAttribute("DateFromFilter", (Object)lastSuccessEndDate);
            log.info((Object)"Transformation type setted to INCREMENTAL");
            return Arc.DEFAULT_ARC;
        }
        nodeToken.getFullEnv().setAttribute("transformationType", "REFRESH");
        log.info((Object)"Transformation type setted to REFRESH");
        return Arc.DEFAULT_ARC;
    }

    private Long findLastSuccessEndDate(String profId) {
        long res = -1L;
        Iterator iter = this.dnetLogger.find("system:profileId", profId);
        while (iter.hasNext()) {
            long curr;
            Map map = (Map)iter.next();
            log.debug((Object)"Iterating on the logs");
            if (!"true".equalsIgnoreCase((String)map.get("system:isCompletedSuccessfully")) || (curr = NumberUtils.toLong((String)((String)map.get("system:endDate")), (long)-1L)) <= res) continue;
            res = curr;
        }
        return res;
    }

    private String findCurrentWfProfileId(NodeToken token) throws MSROException {
        log.debug((Object)"Start to find the current profile Id");
        String p1 = token.getEnv().getAttribute("system:profileId");
        if (p1 != null && !p1.isEmpty()) {
            log.debug((Object)("The profile Id found is " + p1));
            return p1;
        }
        String p2 = token.getFullEnv().getAttribute("system:profileId");
        if (p2 != null && !p2.isEmpty()) {
            log.debug((Object)("The profile Id found is " + p2));
            return p2;
        }
        String p3 = token.getProcess().getEnv().getAttribute("system:profileId");
        if (p3 != null && !p3.isEmpty()) {
            log.debug((Object)("The profile Id found is " + p3));
            return p3;
        }
        throw new MSROException("Missing property in env: system:profileId");
    }

    private String getTransformationId(String workflowId) throws ISLookUpException {
        String query = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//PARAM[./@category='TRANSFORMATION_RULE_ID']/text()";
        ISLookUpService lookUpService = (ISLookUpService)this.locator.getService(ISLookUpService.class);
        String queryInstance = String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//PARAM[./@category='TRANSFORMATION_RULE_ID']/text()", workflowId);
        log.debug((Object)"Query to find the Transformation Rule");
        List transformationId = lookUpService.quickSearchProfile(queryInstance);
        if (transformationId == null || transformationId.isEmpty()) {
            throw new RuntimeException("Error unable to find the Transformation rule ID on workflow profile " + workflowId);
        }
        return (String)transformationId.get(0);
    }

    private Long getLastTransformationRuleUpdate(String trId) throws ISLookUpException {
        String query = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//DATE_OF_CREATION/@value/string()";
        log.debug((Object)("retrieve creation date from transformation ID " + trId));
        ISLookUpService lookUpService = (ISLookUpService)this.locator.getService(ISLookUpService.class);
        String queryInstance = String.format("for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//DATE_OF_CREATION/@value/string()", trId);
        log.debug((Object)"Query to find the Transformation Rule");
        List currentDate = lookUpService.quickSearchProfile(queryInstance);
        if (currentDate == null || currentDate.isEmpty()) {
            throw new RuntimeException("Error unable to find the creation date of the  Transformation rule " + trId);
        }
        return dateUtils.parse((String)currentDate.get(0)).getTime();
    }

    public void setTransformationType(String transformationType) {
        this.transformationType = transformationType;
    }

    public String getTransformationType() {
        return this.transformationType;
    }
}

