<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:utils="eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions"
                exclude-result-prefixes="xs" version="2.0">

    <xsl:param name="parentDatasourceId"/>
    <xsl:param name="namespacePrefix"/>
    <xsl:param name="quote">"</xsl:param>

    <xsl:variable name="funderID" select="concat($namespacePrefix, '::AKA')"/>



    <xsl:variable name="stream" select="normalize-space(.//column[@name='FUNDING STREAM(S)'])"/>
    <xsl:variable name="fundingID">

        <xsl:value-of select="$funderID"/>
    </xsl:variable>

    <xsl:variable name="projectId" select="concat($namespacePrefix, '::',  normalize-space(.//column[@name='Decision No.']))"/>

    <xsl:variable name="fundingPeriod" select="tokenize(.//column[@name='Funding period'],'-')"/>
    <xsl:variable name="startDate" select="normalize-space($fundingPeriod[1])"/>
    <xsl:variable name="endDate" select="normalize-space($fundingPeriod[2])"/>

    <xsl:variable name="dateFormat" select="string('dd.MM.yyyy')"/>
    <xsl:variable name="projectTitle" select="normalize-space(.//column[@name='Project title'])"/>

    <xsl:template match="/">



        <record>

            <xsl:copy-of select=".//*[local-name()='header']"/>
            <metadata>
                <xsl:if test="string-length($projectTitle) &gt; 0 and string-length($projectId) &gt; 0">
                    <ROWS>

                        <ROW table="projects">
                            <FIELD name="_dnet_resource_identifier_">
                                <xsl:value-of select="$projectId"/>
                            </FIELD>
                            <FIELD name="id">
                                <xsl:value-of select="$projectId"/>
                            </FIELD>
                            <FIELD name="code">
                                <xsl:value-of select="normalize-space(.//column[@name='Decision No.'])"/>
                            </FIELD>
                            <FIELD name="startdate" type="date" format="{$dateFormat}">
                                <xsl:value-of select="$startDate"/>
                            </FIELD>
                            <FIELD name="enddate" type="date" format="{$dateFormat}">
                                <xsl:value-of select="$endDate"/>
                            </FIELD>
                            <FIELD name="title">
                                <xsl:value-of select="$projectTitle"/>
                            </FIELD>
                            <FIELD name="call_identifier">
                                <xsl:value-of select=".//column[@name='Call']"/>
                            </FIELD>
                       <!--     <FIELD name="contactfullname">
                                <xsl:value-of select=".//column[@name='Name']"/>
                            </FIELD> -->
                            <FIELD name="optional1">
                                <xsl:value-of select="concat(.//column[@name='Funding'], ' €')"/>
                            </FIELD>
                            <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                            <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                            <FIELD name="collectedfrom">
                                <xsl:value-of select="$parentDatasourceId"/>
                            </FIELD>

                            <FIELD name="oa_mandate_for_publications" type="boolean">false</FIELD>

                        </ROW>



                        <ROW table="project_fundingpath">
                            <FIELD name="_dnet_resource_identifier_">
                                <xsl:value-of select="concat($fundingID,'@@', $projectId)"/>
                            </FIELD>
                            <FIELD name="funding">
                                <xsl:value-of select="$fundingID"/>
                            </FIELD>
                            <FIELD name="project">
                                <xsl:value-of select="$projectId"/>
                            </FIELD>
                            <FIELD name="startdate" type="date" format="{$dateFormat}">
                                <xsl:value-of select="$startDate"/>
                            </FIELD>
                            <FIELD name="enddate" type="date" format="{$dateFormat}">
                                <xsl:value-of select="$endDate"/>
                            </FIELD>
                        </ROW>
                        <xsl:variable name="organizationId" select="concat($namespacePrefix,'::',utils:md5(normalize-space(.//column[@name='Organisation'])))"/>
                        <ROW table = "organizations">
                            <FIELD name="_dnet_resource_identifier_">
                                <xsl:value-of select="$organizationId"/>
                            </FIELD>
                            <FIELD name="id">
                                <xsl:value-of select="$organizationId"/>
                            </FIELD>
                            <FIELD name="legalname">
                                <xsl:value-of select="normalize-space(.//column[@name='Organisation'])"/>
                            </FIELD>
                            <FIELD name="collectedfrom">
                                <xsl:value-of select="$parentDatasourceId"/>
                            </FIELD>
                            <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                            <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                        </ROW>
                        <ROW table="project_organization">
                            <FIELD name="_dnet_resource_identifier_">
                                <xsl:value-of select='concat($projectId, "@@", $organizationId)'/>
                            </FIELD>
                            <FIELD name="project">
                                <xsl:value-of select="$projectId"/>
                            </FIELD>
                            <FIELD name="resporganization">
                                <xsl:value-of select="$organizationId"/>
                            </FIELD>


                            <FIELD name="semanticclass">participant</FIELD>
                            <FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
                        </ROW>
                    </ROWS>
                </xsl:if>
            </metadata>
        </record>

    </xsl:template>
</xsl:stylesheet>