package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import java.util.Map.Entry;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertHostedByApisJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(UpsertHostedByApisJobNode.class);

	private static final String HOSTED_BY_COMPLIANCE = "hostedBy";

	@Autowired
	private LocalOpenaireDatasourceManager dsManager;

	private String countersParam;
	private String mdId;
	public static final String extraFieldsForTotal = "last_aggregation_total";
	public static final String extraFieldForDate = "last_aggregation_date";
	public static final String extraFieldForMdId = "last_aggregation_mdId";

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final HostedByCounters counters = (HostedByCounters) token.getEnv().getTransientAttribute(countersParam);
		final String date = DateUtils.now_ISO8601();
		final String namespacePrefix = token.getEnv().getAttribute("namespacePrefix");

		log.info(counters);

		for (final Entry<String, Integer> e : counters.getCounters().entrySet()) {
			updateHostedByApi(e.getKey(), namespacePrefix, date, e.getValue());
		}

		return Arc.DEFAULT_ARC;
	}

	private void updateHostedByApi(final String dsId,
			final String namepsacePrefix,
			final String date,
			final int size) {
		log.info("Verifying hostedBy api in ds: " + dsId);
		try {

			for (final Api<ApiParam> iface : dsManager.getApis(dsId)) {
				if (HOSTED_BY_COMPLIANCE.equals(iface.getCompatibility())) { return; }
			}

			final Api<ApiParam> api = new Api<>();
			api.setDatasource(dsId);
			api.setId("api_________::" + dsId + "::hostedBy");
			api.setTypology(dsManager.getDs(dsId).getTypology());
			api.setCompatibility(HOSTED_BY_COMPLIANCE);
			api.setProtocol("UNKNOWN");
			api.setContentdescription("metadata");
			api.setBaseurl("");
			api.setActive(false);
			api.setRemovable(true);
			dsManager.addApi(api);
		} catch (final DsmException e) {
			log.warn("Error setting hostedBy api of ds: " + dsId, e);
		}
	}

	public String getMdId() {
		return mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getCountersParam() {
		return countersParam;
	}

	public void setCountersParam(final String countersParam) {
		this.countersParam = countersParam;
	}

}
