/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.nodes.download.DownloadFromMetadataJobNode;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadFromMetadataOpenaire
extends DownloadFromMetadataJobNode {
    private static final Log log = LogFactory.getLog(DownloadFromMetadataOpenaire.class);
    private String basepath;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        if (this.getBasepath() != null && this.getBasepath().length() > 0) {
            job.getParameters().put("basePath", this.basepath);
        }
        int size = ((ObjectStoreService)this.serviceLocator.getService(ObjectStoreService.class)).getSize(this.getObjectStoreID());
        log.debug((Object)String.format("objectStore %s has size %s", this.getObjectStoreID(), size));
        token.getEnv().setAttribute("mainlog:oldTotal", (Object)size);
        super.prepareJob(job, token);
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            protected void populateEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:total", responseParams.get("total"));
                String base64 = responseParams.get("report");
                if (StringUtils.isNotBlank((String)base64) && Base64.isBase64((byte[])base64.getBytes())) {
                    String report = new String(Base64.decodeBase64((byte[])base64.getBytes()));
                    log.info((Object)"found download report");
                    log.debug((Object)report);
                    env.setAttribute("mainlog:report", report);
                } else {
                    log.warn((Object)"unable to find or decode download report");
                }
            }
        };
    }

    public String getBasepath() {
        return this.basepath;
    }

    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }
}

