/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import com.google.common.collect.Maps;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ContextPart {
    private String id;
    private String label;
    private Map<String, String> params = Maps.newLinkedHashMap();
    private Map<String, ContextPart> parts = Maps.newLinkedHashMap();

    public ContextPart() {
    }

    public ContextPart(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Map<String, ContextPart> getParts() {
        return this.parts;
    }

    public void setParts(Map<String, ContextPart> parts) {
        this.parts = parts;
    }

    public void addPart(ContextPart part) {
        if (this.parts.containsKey(part.getId())) {
            ContextPart localChild = this.getParts().get(part.getId());
            for (ContextPart child : part.getParts().values()) {
                localChild.addPart(child);
            }
        } else {
            this.parts.put(part.getId(), part);
        }
    }

    public Element asDomElement(String name) {
        Element elem = DocumentHelper.createElement((String)name);
        elem.addAttribute("id", this.id);
        elem.addAttribute("label", this.label);
        elem.addAttribute("claim", "false");
        for (Map.Entry<String, String> e : this.params.entrySet()) {
            Element p = elem.addElement("param");
            p.addAttribute("name", e.getKey());
            p.setText(e.getValue());
        }
        for (ContextPart child : this.parts.values()) {
            elem.add(child.asDomElement("concept"));
        }
        return elem;
    }
}

