package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import java.io.StringReader;
import java.util.Map;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/**
 * The Class PatchHostedBy.
 */
public class PatchHostedBy implements UnaryFunction<String, String> {

	/**
	 * The set spec hosted by map.
	 */
	private Map<String, HostedByEntry> setSpecHostedByMap;

	/**
	 * The counters.
	 */
	private HostedByCounters counters;

	/**
	 * The xpath.
	 */
	private String xpath;

	/**
	 * The reader.
	 */
	private final SAXReader reader = new SAXReader();

	/**
	 * The Constant log.
	 */
	private static final Log log = LogFactory.getLog(PatchHostedBy.class);

	/**
	 * Instantiates a new patch hosted by.
	 *
	 * @param setSpecHostedByMap the set spec hosted by map
	 * @param xpath              the xpath
	 * @param counters           the counters
	 */
	public PatchHostedBy(final Map<String, HostedByEntry> setSpecHostedByMap, final String xpath, final HostedByCounters counters) {
		this.setSpecHostedByMap = setSpecHostedByMap;
		this.xpath = xpath;
		this.counters = counters;
		if (log.isDebugEnabled()) {
			log.debug("****************************************");
			log.debug("SetSpec/hostedBy map:");
			for (Map.Entry<String, HostedByEntry> e : setSpecHostedByMap.entrySet()) {
				log.debug("   " + e.getKey() + " -> " + e.getValue());
			}
			log.debug("****************************************");
		}
	}

	/**
	 * Evaluate.
	 *
	 * @param record the record
	 * @return the string
	 */
	@Override
	public String evaluate(final String record) {
		try {
			final Document doc = reader.read(new StringReader(record));
			final Element node = (Element) doc.selectSingleNode("//*[local-name()='hostedBy']");
			if (node != null) {
				final HostedByEntry ds = findHostedBy(doc);
				if (ds != null) {
					node.addAttribute("id", ds.getId());
					node.addAttribute("name", ds.getName());
					counters.increaseCounter(ds.getId());
				}
				return doc.asXML();
			} else if (log.isDebugEnabled()) {
				log.debug(" -- Missing hostedBy --");
			}
		} catch (Throwable e) {
			log.error("Error adding hosted by to " + record);
		}
		return record;
	}

	/**
	 * Find hosted by.
	 *
	 * @param doc the doc
	 * @return the hosted by entry
	 */
	private HostedByEntry findHostedBy(final Document doc) {
		for (Object o : doc.selectNodes(this.xpath)) {
			final String set = ((Node) o).getText().trim();
			if (setSpecHostedByMap.containsKey(set)) {
				if (log.isDebugEnabled()) {
					log.debug(set + " -> " + setSpecHostedByMap.get(set));
				}
				return setSpecHostedByMap.get(set);
			} else if (log.isDebugEnabled()) {
				log.debug(set + " -> UNKNOWN REPO");
			}
		}
		return null;
	}

}
