/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Value;

public class SwitchIndexesJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(SwitchIndexesJobNode.class);
    @Value(value="dnet.openaire.index.api.cacheEvictUrl")
    private String indexApiCacheEvictUrl;

    protected String execute(NodeToken token) throws Exception {
        Queue q = (Queue)token.getEnv().getTransientAttribute("searchService_ids");
        log.debug((Object)("Got the searchService_ids queue: " + q.toString()));
        if (q == null) {
            throw new MSROException("Transient param 'searchService_ids' with queue of string could not be found");
        }
        if (q.isEmpty()) {
            log.info((Object)"searchService_ids queue consumed, now ending cycle and evicting direct indexing api cache");
            HttpGet get = new HttpGet(this.indexApiCacheEvictUrl);
            CloseableHttpClient httpclient = HttpClients.createDefault();
            Throwable throwable = null;
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    String string = Arc.DEFAULT_ARC;
                    return string;
                }
                try {
                    throw new MSROException("Cannot evict cache of direct indexing API at: " + this.indexApiCacheEvictUrl);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        String id = (String)q.poll();
        log.debug((Object)("Polled id: " + id));
        log.debug((Object)("And now the queue is " + q));
        token.getEnv().setAttribute("search_service_ID", id);
        log.debug((Object)("Asking to switch on profile with id: " + id));
        token.getEnv().setTransientAttribute("searchService_ids", (Object)q);
        return "switch";
    }
}

