/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.openaireplus.workflows.nodes.datacite.IteratorOnQueue;
import eu.dnetlib.msro.openaireplus.workflows.nodes.datacite.SplitterDatasetsIterator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class SplitDatasetRecord
extends SimpleJobNode {
    private String inputEprParm;
    private String outputEprParm;
    private ResultSetClientFactory resultSetClientFactory;
    @Resource(name="iterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;
    private Executor executor = Executors.newSingleThreadExecutor();

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.inputEprParm));
        IterableResultSetClient input = this.resultSetClientFactory.getClient(inputEpr);
        final LinkedBlockingQueue<String> publicationsQueue = new LinkedBlockingQueue<String>();
        final SplitterDatasetsIterator splitterIterator = new SplitterDatasetsIterator(publicationsQueue, (Iterable<String>)input, "publications");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                splitterIterator.populateQueues();
            }
        });
        W3CEndpointReference eprUrls_publications = this.resultSetFactory.createIterableResultSet((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new IteratorOnQueue<String>(publicationsQueue, SplitterDatasetsIterator.END_QUEUE);
            }
        });
        token.getEnv().setAttribute(this.getOutputEprParm(), eprUrls_publications.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParm() {
        return this.inputEprParm;
    }

    public void setInputEprParm(String inputEprParm) {
        this.inputEprParm = inputEprParm;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public String getOutputEprParm() {
        return this.outputEprParm;
    }

    public void setOutputEprParm(String outputEprParm) {
        this.outputEprParm = outputEprParm;
    }
}

