/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.consistency;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FindInvalidWorkflowsJobNode
extends SimpleJobNode {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private static final Log log = LogFactory.getLog(FindInvalidWorkflowsJobNode.class);
    private boolean deleteInvalidProfiles = false;

    protected String execute(NodeToken token) throws Exception {
        ISLookUpService lookup = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        ISRegistryService registry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        String q1 = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType')//WORKFLOW/@id|//CONFIGURATION/@destroyWorkflow return $x/string()";
        String q2 = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()";
        HashSet valids = new HashSet(lookup.quickSearchProfile("for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType')//WORKFLOW/@id|//CONFIGURATION/@destroyWorkflow return $x/string()"));
        int count = 0;
        int countInvalids = 0;
        int countDeleted = 0;
        for (String wfId : lookup.quickSearchProfile("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()")) {
            ++count;
            if (valids.contains(wfId)) continue;
            log.warn((Object)("Invalid wf: " + wfId));
            ++countInvalids;
            if (!this.deleteInvalidProfiles) continue;
            registry.deleteProfile(wfId);
            log.info((Object)" -- Deleted");
            ++countDeleted;
        }
        token.getEnv().setAttribute("mainlog:total", (Object)count);
        token.getEnv().setAttribute("mainlog:invalid", (Object)countInvalids);
        token.getEnv().setAttribute("mainlog:deleted", (Object)countDeleted);
        return Arc.DEFAULT_ARC;
    }

    public boolean isDeleteInvalidProfiles() {
        return this.deleteInvalidProfiles;
    }

    public void setDeleteInvalidProfiles(boolean deleteInvalidProfiles) {
        this.deleteInvalidProfiles = deleteInvalidProfiles;
    }
}

