/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Value;

public class SwitchIndexesJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(SwitchIndexesJobNode.class);
    @Value(value="dnet.openaire.index.api.cacheEvictUrl")
    private String indexApiCacheEvictUrl;

    protected String execute(NodeToken token) throws Exception {
        Queue q;
        block29: {
            q = (Queue)token.getEnv().getTransientAttribute("searchService_ids");
            log.debug((Object)("Got the searchService_ids queue: " + q.toString()));
            if (q == null) {
                throw new MSROException("Transient param 'searchService_ids' with queue of string could not be found");
            }
            if (!q.isEmpty()) break block29;
            log.info((Object)("searchService_ids queue consumed, now ending cycle and evicting direct indexing api cache on " + this.indexApiCacheEvictUrl));
            HttpGet get = new HttpGet(this.indexApiCacheEvictUrl);
            Throwable throwable = null;
            try (CloseableHttpClient client = HttpClients.createDefault();){
                Throwable throwable2;
                CloseableHttpResponse response;
                block26: {
                    String string;
                    block27: {
                        block28: {
                            response = client.execute((HttpUriRequest)get);
                            throwable2 = null;
                            int statusCode = response.getStatusLine().getStatusCode();
                            log.info((Object)String.format("GET on %s returned %s", this.indexApiCacheEvictUrl, statusCode));
                            if (statusCode != 200) break block26;
                            string = Arc.DEFAULT_ARC;
                            if (response == null) break block27;
                            if (throwable2 == null) break block28;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            break block27;
                        }
                        response.close();
                    }
                    return string;
                }
                try {
                    try {
                        try {
                            throw new MSROException("Cannot evict cache of direct indexing API at: " + this.indexApiCacheEvictUrl);
                        }
                        catch (Throwable throwable4) {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (response != null) {
                            if (throwable2 != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                response.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
            }
        }
        String id = (String)q.poll();
        log.debug((Object)("Polled id: " + id));
        log.debug((Object)("And now the queue is " + q));
        token.getEnv().setAttribute("search_service_ID", id);
        log.debug((Object)("Asking to switch on profile with id: " + id));
        token.getEnv().setTransientAttribute("searchService_ids", (Object)q);
        return "switch";
    }
}

