package eu.dnetlib.msro.openaireplus.workflows.nodes.vre;

import java.net.URI;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

/**
 * Created by alessia on 24/03/16.
 */
public class VREPostJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(VREPostJobNode.class);
	private String scheme;
	private String host;
	private String postPath;

	//POST parameters
	private String appToken;
	private String previewTitle;
	private String previewDescription;
	private String text;
	private String httpImageUrl;
	private boolean enableNotification;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		CloseableHttpClient httpclient = HttpClients.createDefault();
		try {
			URI postUri = new URIBuilder().setScheme(scheme).setHost(host).setPath(postPath).build();
			HttpPost postAction = new HttpPost(postUri);
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.append("gcube-token=").append(appToken).append("&previewtitle=").append(previewTitle)
					.append("&previewdescription=").append(previewDescription).append("&text=").append(text)
					.append("&httpimageurl=").append(httpImageUrl).append("&enablenotification=").append(enableNotification);
			String postBody = strBuilder.toString();
			log.debug("POST body: " + postBody);
			StringEntity ent = new StringEntity(postBody, ContentType.APPLICATION_FORM_URLENCODED);

			postAction.setEntity(ent);

			BasicResponseHandler responseHandler = new BasicResponseHandler();

			httpclient.execute(postAction, responseHandler);
			return Arc.DEFAULT_ARC;
		} finally {
			httpclient.close();
		}

	}

	public String getScheme() {
		return scheme;
	}

	public void setScheme(final String scheme) {
		this.scheme = scheme;
	}

	public String getHost() {
		return host;
	}

	public void setHost(final String host) {
		this.host = host;
	}

	public String getPostPath() {
		return postPath;
	}

	public void setPostPath(final String postPath) {
		this.postPath = postPath;
	}

	public String getAppToken() {
		return appToken;
	}

	public void setAppToken(final String token) {
		this.appToken = token;
	}

	public String getPreviewTitle() {
		return previewTitle;
	}

	public void setPreviewTitle(final String previewTitle) {
		this.previewTitle = previewTitle;
	}

	public String getPreviewDescription() {
		return previewDescription;
	}

	public void setPreviewDescription(final String previewDescription) {
		this.previewDescription = previewDescription;
	}

	public String getText() {
		return text;
	}

	public void setText(final String text) {
		this.text = text;
	}

	public String getHttpImageUrl() {
		return httpImageUrl;
	}

	public void setHttpImageUrl(final String httpImageUrl) {
		this.httpImageUrl = httpImageUrl;
	}

	public boolean isEnableNotification() {
		return enableNotification;
	}

	public void setEnableNotification(final boolean enablenotification) {
		this.enableNotification = enablenotification;
	}
}
