/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.vre;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

public class VREPostJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(VREPostJobNode.class);
    private String scheme;
    private String host;
    private String postPath;
    private String appToken;
    private String previewTitle;
    private String previewDescription;
    private String text;
    private String httpImageUrl;
    private boolean enableNotification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String execute(NodeToken token) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            URI postUri = new URIBuilder().setScheme(this.scheme).setHost(this.host).setPath(this.postPath).build();
            HttpPost postAction = new HttpPost(postUri);
            JSONObject obj = this.createPostBody();
            postAction.addHeader("gcube-token", this.appToken);
            postAction.addHeader("Content-type", ContentType.APPLICATION_JSON.toString());
            StringEntity params = new StringEntity(obj.toString(), ContentType.APPLICATION_JSON);
            postAction.setEntity((HttpEntity)params);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)postAction);
            log.debug((Object)(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase()));
            int status = response.getStatusLine().getStatusCode();
            if (status != 200 && (status == 302 || status == 301 || status == 303)) {
                Header[] locations = response.getHeaders("Location");
                Header lastLocation = locations[locations.length - 1];
                String realLocation = lastLocation.getValue();
                log.info((Object)("New location after redirect for posting is " + realLocation));
                postAction.setURI(new URI(realLocation));
                response = httpclient.execute((HttpUriRequest)postAction);
                log.debug((Object)(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase()));
            } else {
                log.debug((Object)(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase()));
            }
            String string = Arc.DEFAULT_ARC;
            return string;
        }
    }

    protected JSONObject createPostBody() {
        JSONObject obj = new JSONObject();
        obj.put("text", (Object)this.text);
        obj.put("preview_title", (Object)this.previewTitle);
        obj.put("preview_description", (Object)this.previewDescription);
        obj.put("image_url", (Object)this.httpImageUrl);
        obj.put("enable_notification", (Object)Boolean.toString(this.enableNotification));
        log.debug((Object)("POST body: " + obj.toString()));
        return obj;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPostPath() {
        return this.postPath;
    }

    public void setPostPath(String postPath) {
        this.postPath = postPath;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String token) {
        this.appToken = token;
    }

    public String getPreviewTitle() {
        return this.previewTitle;
    }

    public void setPreviewTitle(String previewTitle) {
        this.previewTitle = previewTitle;
    }

    public String getPreviewDescription() {
        return this.previewDescription;
    }

    public void setPreviewDescription(String previewDescription) {
        this.previewDescription = previewDescription;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getHttpImageUrl() {
        return this.httpImageUrl;
    }

    public void setHttpImageUrl(String httpImageUrl) {
        this.httpImageUrl = httpImageUrl;
    }

    public boolean isEnableNotification() {
        return this.enableNotification;
    }

    public void setEnableNotification(boolean enablenotification) {
        this.enableNotification = enablenotification;
    }
}

