/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IncrementalOperationJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(IncrementalOperationJobNode.class);
    private String operationType;
    @Autowired
    private DnetLogger dnetLogger;

    protected String execute(NodeToken nodeToken) throws Exception {
        if ("incremental".equalsIgnoreCase(this.operationType)) {
            String currentWfProfileId = this.findCurrentWfProfileId(nodeToken);
            Long lastSuccessEndDate = this.findLastSuccessEndDate(currentWfProfileId);
            if (this.forceRefresh(nodeToken, lastSuccessEndDate, currentWfProfileId)) {
                return Arc.DEFAULT_ARC;
            }
            log.info((Object)("Last success date " + lastSuccessEndDate));
            nodeToken.getFullEnv().setAttribute("OperationTypeInfo", "Operation type set to INCREMENTAL with date " + DateUtils.calculate_ISO8601((long)lastSuccessEndDate));
            nodeToken.getFullEnv().setAttribute("operationType", "INCREMENTAL");
            nodeToken.getFullEnv().setAttribute("DateFromFilter", (Object)lastSuccessEndDate);
            return Arc.DEFAULT_ARC;
        }
        nodeToken.getFullEnv().setAttribute("operationType", "REFRESH");
        nodeToken.getFullEnv().setAttribute("OperationTypeInfo", "Operation type manually set to REFRESH");
        return Arc.DEFAULT_ARC;
    }

    protected boolean forceRefresh(NodeToken nodeToken, Long lastSuccessEndDate, String currentWfProfileId) throws Exception {
        if (lastSuccessEndDate < 0L) {
            nodeToken.getFullEnv().setAttribute("OperationTypeInfo", "Last success date < 0, operation forced to REFRESH");
            nodeToken.getFullEnv().setAttribute("operationType", "REFRESH");
            return true;
        }
        return false;
    }

    private Long findLastSuccessEndDate(String profId) {
        long res = -1L;
        Iterator iter = this.dnetLogger.find("system:profileId", profId);
        while (iter.hasNext()) {
            long curr;
            Map map = (Map)iter.next();
            log.debug((Object)"Iterating on the logs");
            if (!"true".equalsIgnoreCase((String)map.get("system:isCompletedSuccessfully")) || (curr = NumberUtils.toLong((String)((String)map.get("system:endDate")), (long)-1L)) <= res) continue;
            res = curr;
        }
        return res;
    }

    private String findCurrentWfProfileId(NodeToken token) throws MSROException {
        log.debug((Object)"Start to find the current profile Id");
        String p1 = token.getEnv().getAttribute("system:profileId");
        if (p1 != null && !p1.isEmpty()) {
            log.debug((Object)("The profile Id found is " + p1));
            return p1;
        }
        String p2 = token.getFullEnv().getAttribute("system:profileId");
        if (p2 != null && !p2.isEmpty()) {
            log.debug((Object)("The profile Id found is " + p2));
            return p2;
        }
        String p3 = token.getProcess().getEnv().getAttribute("system:profileId");
        if (p3 != null && !p3.isEmpty()) {
            log.debug((Object)("The profile Id found is " + p3));
            return p3;
        }
        throw new MSROException("Missing property in env: system:profileId");
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }
}

