package eu.dnetlib.msro.openaireplus.workflows.nodes.vre;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

/**
 * Created by alessia on 24/03/16.
 */
public class VREPostJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(VREPostJobNode.class);
	private String scheme;
	private String host;
	private String postPath;
	private int followRedirect = 10;

	//POST parameters
	private String appToken;
	private String previewTitle;
	private String previewDescription;
	private String text;
	private String httpImageUrl;
	private boolean enableNotification;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		CloseableHttpClient httpclient = HttpClients.createDefault();
		try {
			URI postUri = new URIBuilder().setScheme(scheme).setHost(host).setPath(postPath).build();
			HttpPost postAction = new HttpPost(postUri);

			JSONObject obj = createPostBody();

			postAction.addHeader("gcube-token", appToken);
			postAction.addHeader("Content-type", ContentType.APPLICATION_JSON.toString());

			StringEntity params = new StringEntity(obj.toString(), ContentType.APPLICATION_JSON);
			postAction.setEntity(params);

			return doPost(httpclient, postAction, followRedirect);
		} finally {
			httpclient.close();
		}

	}

	protected String doPost(HttpClient httpclient, HttpPost postAction, int followRedirect) throws IOException, URISyntaxException {
		HttpResponse response = httpclient.execute(postAction);
		log.debug(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase());
		int status = response.getStatusLine().getStatusCode();
		switch (status) {
		case HttpURLConnection.HTTP_OK:
		case HttpURLConnection.HTTP_CREATED:
			return Arc.DEFAULT_ARC;
		case HttpURLConnection.HTTP_MOVED_TEMP:
		case HttpURLConnection.HTTP_MOVED_PERM:
		case HttpURLConnection.HTTP_SEE_OTHER:
			if (followRedirect > 0) {
				Header[] locations = response.getHeaders("Location");
				Header lastLocation = locations[locations.length - 1];
				String realLocation = lastLocation.getValue();
				log.info("New location after redirect for posting is " + realLocation);

				// perform again the same request
				postAction.setURI(new URI(realLocation));
				return doPost(httpclient, postAction, followRedirect--);
			} else
				throw new RuntimeException("Too many redirects to post on the VRE");
		}
		throw new RuntimeException("HTTP error code " + status);
	}

	protected JSONObject createPostBody() {
		JSONObject obj = new JSONObject();
		obj.put("text", text);
		obj.put("preview_title", previewTitle);
		obj.put("preview_description", previewDescription);
		obj.put("image_url", httpImageUrl);
		obj.put("enable_notification", Boolean.toString(enableNotification));
		log.debug("POST body: " + obj.toString());
		return obj;
	}

	public String getScheme() {
		return scheme;
	}

	public void setScheme(final String scheme) {
		this.scheme = scheme;
	}

	public String getHost() {
		return host;
	}

	public void setHost(final String host) {
		this.host = host;
	}

	public String getPostPath() {
		return postPath;
	}

	public void setPostPath(final String postPath) {
		this.postPath = postPath;
	}

	public String getAppToken() {
		return appToken;
	}

	public void setAppToken(final String token) {
		this.appToken = token;
	}

	public String getPreviewTitle() {
		return previewTitle;
	}

	public void setPreviewTitle(final String previewTitle) {
		this.previewTitle = previewTitle;
	}

	public String getPreviewDescription() {
		return previewDescription;
	}

	public void setPreviewDescription(final String previewDescription) {
		this.previewDescription = previewDescription;
	}

	public String getText() {
		return text;
	}

	public void setText(final String text) {
		this.text = text;
	}

	public String getHttpImageUrl() {
		return httpImageUrl;
	}

	public void setHttpImageUrl(final String httpImageUrl) {
		this.httpImageUrl = httpImageUrl;
	}

	public boolean isEnableNotification() {
		return enableNotification;
	}

	public void setEnableNotification(final boolean enablenotification) {
		this.enableNotification = enablenotification;
	}
}
