/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.openaireplus.workflows.nodes.IncrementalOperationJobNode;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IncrementalTransformationJobNode
extends IncrementalOperationJobNode {
    private static final Log log = LogFactory.getLog(IncrementalTransformationJobNode.class);
    @Autowired
    private UniqueServiceLocator locator;
    private static final DateUtils dateUtils = new DateUtils();

    @Override
    protected boolean forceRefresh(NodeToken nodeToken, Long lastSuccessEndDate, String currentWfProfileId) throws Exception {
        if (lastSuccessEndDate < 0L) {
            nodeToken.getFullEnv().setAttribute("OperationTypeInfo", "Last success date < 0, transformation forced to REFRESH");
            nodeToken.getFullEnv().setAttribute("operationType", "REFRESH");
            return true;
        }
        String trRuleId = this.getTransformationId(currentWfProfileId);
        long lastUpdateDate = this.getLastTransformationRuleUpdate(trRuleId);
        log.info((Object)String.format("Last update date of the transformation rule with id %s is %s", trRuleId, DateUtils.calculate_ISO8601((long)lastUpdateDate)));
        if (lastUpdateDate > lastSuccessEndDate) {
            nodeToken.getFullEnv().setAttribute("OperationTypeInfo", "Transformation Rule has been updated, transformation forced to REFRESH");
            nodeToken.getFullEnv().setAttribute("operationType", "REFRESH");
            return true;
        }
        return false;
    }

    private String getTransformationId(String workflowId) throws ISLookUpException {
        String query = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//PARAM[./@category='TRANSFORMATION_RULE_ID']/text()";
        ISLookUpService lookUpService = (ISLookUpService)this.locator.getService(ISLookUpService.class);
        String queryInstance = String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//PARAM[./@category='TRANSFORMATION_RULE_ID']/text()", workflowId);
        log.debug((Object)"Query to find the Transformation Rule");
        List transformationId = lookUpService.quickSearchProfile(queryInstance);
        if (transformationId == null || transformationId.isEmpty()) {
            throw new RuntimeException("Error unable to find the Transformation rule ID on workflow profile " + workflowId);
        }
        return (String)transformationId.get(0);
    }

    private Long getLastTransformationRuleUpdate(String trId) throws ISLookUpException {
        String query = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//DATE_OF_CREATION/@value/string()";
        log.debug((Object)("retrieve creation date from transformation ID " + trId));
        ISLookUpService lookUpService = (ISLookUpService)this.locator.getService(ISLookUpService.class);
        String queryInstance = String.format("for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//DATE_OF_CREATION/@value/string()", trId);
        log.debug((Object)"Query to find the Transformation Rule");
        List currentDate = lookUpService.quickSearchProfile(queryInstance);
        if (currentDate == null || currentDate.isEmpty()) {
            throw new RuntimeException("Error unable to find the creation date of the  Transformation rule " + trId);
        }
        return dateUtils.parse((String)currentDate.get(0)).getTime();
    }
}

