/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwitchSearchServiceJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(SwitchSearchServiceJobNode.class);
    private static final String BB_ACTION_SWITCH_INDEX = "UpdateIndex";
    private String inputIndexIdParam;
    private String outputIndexIdParam;

    protected String obtainServiceId(NodeToken token) {
        String id = token.getEnv().getAttribute("search_service_ID");
        if (StringUtils.isBlank((String)id)) {
            throw new RuntimeException("No id found in env attribute 'search_service_ID'");
        }
        return id;
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        job.setAction(BB_ACTION_SWITCH_INDEX);
        String indexId = token.getEnv().getAttribute(this.getInputIndexIdParam());
        this.checkParam(this.getInputIndexIdParam(), "output indexId param is missing");
        this.checkParam(indexId, "indexId is required to perform switch");
        log.info((Object)("Switching " + this.obtainServiceId(token) + " to index " + indexId));
        job.getParameters().put(this.getOutputIndexIdParam(), indexId);
    }

    private void checkParam(String param, String msg) throws MSROException {
        if (StringUtils.isBlank((String)param)) {
            throw new MSROException(msg);
        }
    }

    public String getInputIndexIdParam() {
        return this.inputIndexIdParam;
    }

    public void setInputIndexIdParam(String inputIndexIdParam) {
        this.inputIndexIdParam = inputIndexIdParam;
    }

    public String getOutputIndexIdParam() {
        return this.outputIndexIdParam;
    }

    public void setOutputIndexIdParam(String outputIndexIdParam) {
        this.outputIndexIdParam = outputIndexIdParam;
    }
}

