package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.openaireplus.workflows.nodes.actions.PromoteActionsJobNode;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;

public class ListActionManagerSetsValues extends ValidNodeValuesFetcher {

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {

		final String xquery =
				"for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ActionManagerSetDSResourceType'] return concat($x//SET/@id, ' @@@ ', $x//SET) ";

		final List<String> result = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
		final List<DnetParamValue> values = Lists.newArrayList(new DnetParamValue("", PromoteActionsJobNode.ALL_SETS));

		for (final String s : result) {
			final String[] arr = s.split("@@@");
			values.add(new DnetParamValue(arr[0].trim(), arr[1].trim()));
		}

		return values;
	}

}
